/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.ratelimit.config;

import com.tencent.cloud.polaris.context.ServiceRuleManager;
import com.tencent.cloud.polaris.context.config.PolarisContextAutoConfiguration;
import com.tencent.cloud.polaris.ratelimit.config.ConditionalOnPolarisRateLimitEnabled;
import com.tencent.cloud.polaris.ratelimit.config.PolarisRateLimitProperties;
import com.tencent.cloud.polaris.ratelimit.filter.QuotaCheckReactiveFilter;
import com.tencent.cloud.polaris.ratelimit.filter.QuotaCheckServletFilter;
import com.tencent.cloud.polaris.ratelimit.resolver.RateLimitRuleArgumentReactiveResolver;
import com.tencent.cloud.polaris.ratelimit.resolver.RateLimitRuleArgumentServletResolver;
import com.tencent.cloud.polaris.ratelimit.spi.PolarisRateLimiterLabelReactiveResolver;
import com.tencent.cloud.polaris.ratelimit.spi.PolarisRateLimiterLabelServletResolver;
import com.tencent.cloud.polaris.ratelimit.spi.PolarisRateLimiterLimitedFallback;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.ratelimit.api.core.LimitAPI;
import com.tencent.polaris.ratelimit.factory.LimitAPIFactory;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={PolarisContextAutoConfiguration.class})
@ConditionalOnPolarisRateLimitEnabled
public class PolarisRateLimitAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public LimitAPI limitAPI(SDKContext polarisContext) {
        return LimitAPIFactory.createLimitAPIByContext((SDKContext)polarisContext);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    protected static class MetadataReactiveFilterConfig {
        protected MetadataReactiveFilterConfig() {
        }

        @Bean
        public RateLimitRuleArgumentReactiveResolver rateLimitRuleArgumentResolver(ServiceRuleManager serviceRuleManager, @Autowired(required=false) PolarisRateLimiterLabelReactiveResolver labelResolver) {
            return new RateLimitRuleArgumentReactiveResolver(serviceRuleManager, labelResolver);
        }

        @Bean
        public QuotaCheckReactiveFilter quotaCheckReactiveFilter(LimitAPI limitAPI, PolarisRateLimitProperties polarisRateLimitProperties, RateLimitRuleArgumentReactiveResolver rateLimitRuleArgumentResolver, @Nullable PolarisRateLimiterLimitedFallback polarisRateLimiterLimitedFallback) {
            return new QuotaCheckReactiveFilter(limitAPI, polarisRateLimitProperties, rateLimitRuleArgumentResolver, polarisRateLimiterLimitedFallback);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    protected static class QuotaCheckFilterConfig {
        protected QuotaCheckFilterConfig() {
        }

        @Bean
        public RateLimitRuleArgumentServletResolver rateLimitRuleArgumentResolver(ServiceRuleManager serviceRuleManager, @Autowired(required=false) PolarisRateLimiterLabelServletResolver labelResolver) {
            return new RateLimitRuleArgumentServletResolver(serviceRuleManager, labelResolver);
        }

        @Bean
        @ConditionalOnMissingBean
        public QuotaCheckServletFilter quotaCheckFilter(LimitAPI limitAPI, PolarisRateLimitProperties polarisRateLimitProperties, RateLimitRuleArgumentServletResolver rateLimitRuleArgumentResolver, @Autowired(required=false) PolarisRateLimiterLimitedFallback polarisRateLimiterLimitedFallback) {
            return new QuotaCheckServletFilter(limitAPI, polarisRateLimitProperties, rateLimitRuleArgumentResolver, polarisRateLimiterLimitedFallback);
        }

        @Bean
        public FilterRegistrationBean<QuotaCheckServletFilter> quotaFilterRegistrationBean(QuotaCheckServletFilter quotaCheckServletFilter) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)quotaCheckServletFilter, new ServletRegistrationBean[0]);
            registrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
            registrationBean.setName("quotaFilterRegistrationBean");
            registrationBean.setOrder(-2147483638);
            return registrationBean;
        }
    }
}

