/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.ratelimit.endpoint;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.util.JacksonUtils;
import com.tencent.cloud.polaris.context.ServiceRuleManager;
import com.tencent.cloud.polaris.ratelimit.config.PolarisRateLimitProperties;
import com.tencent.polaris.specification.api.v1.traffic.manage.RateLimitProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.util.CollectionUtils;

@Endpoint(id="polaris-ratelimit")
public class PolarisRateLimitRuleEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(PolarisRateLimitRuleEndpoint.class);
    private final ServiceRuleManager serviceRuleManager;
    private final PolarisRateLimitProperties polarisRateLimitProperties;

    public PolarisRateLimitRuleEndpoint(ServiceRuleManager serviceRuleManager, PolarisRateLimitProperties polarisRateLimitProperties) {
        this.serviceRuleManager = serviceRuleManager;
        this.polarisRateLimitProperties = polarisRateLimitProperties;
    }

    @ReadOperation
    public Map<String, Object> rateLimit() {
        RateLimitProto.RateLimit rateLimit = this.serviceRuleManager.getServiceRateLimitRule(MetadataContext.LOCAL_NAMESPACE, MetadataContext.LOCAL_SERVICE);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("properties", this.polarisRateLimitProperties);
        result.put("namespace", MetadataContext.LOCAL_NAMESPACE);
        result.put("service", MetadataContext.LOCAL_SERVICE);
        result.put("rateLimitRules", this.parseRateLimitRule(rateLimit));
        return result;
    }

    private List<Object> parseRateLimitRule(RateLimitProto.RateLimit rateLimit) {
        ArrayList<Object> rateLimitRule = new ArrayList<Object>();
        if (rateLimit == null || CollectionUtils.isEmpty((Collection)rateLimit.getRulesList())) {
            return rateLimitRule;
        }
        for (RateLimitProto.Rule rule : rateLimit.getRulesList()) {
            String ruleJson;
            try {
                ruleJson = JsonFormat.printer().print((MessageOrBuilder)rule);
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error("rule to Json failed. check rule {}.", (Object)rule, (Object)e);
                throw new RuntimeException("Json failed.", e);
            }
            rateLimitRule.add(JacksonUtils.deserialize2Map((String)ruleJson));
        }
        return rateLimitRule;
    }
}

