/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.ratelimit.filter;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.polaris.ratelimit.config.PolarisRateLimitProperties;
import com.tencent.cloud.polaris.ratelimit.resolver.RateLimitRuleArgumentReactiveResolver;
import com.tencent.cloud.polaris.ratelimit.spi.PolarisRateLimiterLimitedFallback;
import com.tencent.cloud.polaris.ratelimit.utils.QuotaCheckUtils;
import com.tencent.cloud.polaris.ratelimit.utils.RateLimitUtils;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.ratelimit.api.core.LimitAPI;
import com.tencent.polaris.ratelimit.api.rpc.Argument;
import com.tencent.polaris.ratelimit.api.rpc.QuotaResponse;
import com.tencent.polaris.ratelimit.api.rpc.QuotaResultCode;
import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class QuotaCheckReactiveFilter
implements WebFilter,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuotaCheckReactiveFilter.class);
    private final LimitAPI limitAPI;
    private final PolarisRateLimitProperties polarisRateLimitProperties;
    private final RateLimitRuleArgumentReactiveResolver rateLimitRuleArgumentResolver;
    private final PolarisRateLimiterLimitedFallback polarisRateLimiterLimitedFallback;
    private String rejectTips;

    public QuotaCheckReactiveFilter(LimitAPI limitAPI, PolarisRateLimitProperties polarisRateLimitProperties, RateLimitRuleArgumentReactiveResolver rateLimitRuleArgumentResolver, @Nullable PolarisRateLimiterLimitedFallback polarisRateLimiterLimitedFallback) {
        this.limitAPI = limitAPI;
        this.polarisRateLimitProperties = polarisRateLimitProperties;
        this.rateLimitRuleArgumentResolver = rateLimitRuleArgumentResolver;
        this.polarisRateLimiterLimitedFallback = polarisRateLimiterLimitedFallback;
    }

    @PostConstruct
    public void init() {
        this.rejectTips = RateLimitUtils.getRejectTips(this.polarisRateLimitProperties);
    }

    public int getOrder() {
        return -2147483638;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String localNamespace = MetadataContext.LOCAL_NAMESPACE;
        String localService = MetadataContext.LOCAL_SERVICE;
        Set<Argument> arguments = this.rateLimitRuleArgumentResolver.getArguments(exchange, localNamespace, localService);
        long waitMs = -1L;
        try {
            String path = exchange.getRequest().getURI().getPath();
            QuotaResponse quotaResponse = QuotaCheckUtils.getQuota(this.limitAPI, localNamespace, localService, 1, arguments, path);
            if (quotaResponse.getCode() == QuotaResultCode.QuotaResultLimited) {
                DataBuffer dataBuffer;
                ServerHttpResponse response = exchange.getResponse();
                if (!Objects.isNull(this.polarisRateLimiterLimitedFallback)) {
                    response.setRawStatusCode(this.polarisRateLimiterLimitedFallback.rejectHttpCode());
                    response.getHeaders().setContentType(this.polarisRateLimiterLimitedFallback.mediaType());
                    dataBuffer = response.bufferFactory().allocateBuffer().write(this.polarisRateLimiterLimitedFallback.rejectTips().getBytes(this.polarisRateLimiterLimitedFallback.charset()));
                } else {
                    response.setRawStatusCode(Integer.valueOf(this.polarisRateLimitProperties.getRejectHttpCode()));
                    response.getHeaders().setContentType(MediaType.TEXT_HTML);
                    dataBuffer = response.bufferFactory().allocateBuffer().write(this.rejectTips.getBytes(StandardCharsets.UTF_8));
                }
                response.getHeaders().add("internal-callee-retstatus", RetStatus.RetFlowControl.getDesc());
                if (Objects.nonNull(quotaResponse.getActiveRule())) {
                    response.getHeaders().add("internal-callee-activerule", quotaResponse.getActiveRule().getName().getValue());
                }
                return response.writeWith((Publisher)Mono.just((Object)dataBuffer));
            }
            if (quotaResponse.getCode() == QuotaResultCode.QuotaResultOk && quotaResponse.getWaitMs() > 0L) {
                LOGGER.debug("The request of [{}] will waiting for {}ms.", (Object)path, (Object)quotaResponse.getWaitMs());
                waitMs = quotaResponse.getWaitMs();
            }
        }
        catch (Throwable t) {
            LOGGER.error("fail to invoke getQuota, service is " + localService, t);
        }
        if (waitMs > 0L) {
            return Mono.delay((Duration)Duration.ofMillis(waitMs)).flatMap(e -> chain.filter(exchange));
        }
        return chain.filter(exchange);
    }
}

