/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.ratelimit.filter;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.polaris.ratelimit.config.PolarisRateLimitProperties;
import com.tencent.cloud.polaris.ratelimit.resolver.RateLimitRuleArgumentServletResolver;
import com.tencent.cloud.polaris.ratelimit.spi.PolarisRateLimiterLimitedFallback;
import com.tencent.cloud.polaris.ratelimit.utils.QuotaCheckUtils;
import com.tencent.cloud.polaris.ratelimit.utils.RateLimitUtils;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.ratelimit.api.core.LimitAPI;
import com.tencent.polaris.ratelimit.api.rpc.Argument;
import com.tencent.polaris.ratelimit.api.rpc.QuotaResponse;
import com.tencent.polaris.ratelimit.api.rpc.QuotaResultCode;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=-2147483638)
public class QuotaCheckServletFilter
extends OncePerRequestFilter {
    public static final String QUOTA_FILTER_BEAN_NAME = "quotaFilterRegistrationBean";
    private static final Logger LOG = LoggerFactory.getLogger(QuotaCheckServletFilter.class);
    private final LimitAPI limitAPI;
    private final PolarisRateLimitProperties polarisRateLimitProperties;
    private final RateLimitRuleArgumentServletResolver rateLimitRuleArgumentResolver;
    private final PolarisRateLimiterLimitedFallback polarisRateLimiterLimitedFallback;
    private String rejectTips;

    public QuotaCheckServletFilter(LimitAPI limitAPI, PolarisRateLimitProperties polarisRateLimitProperties, RateLimitRuleArgumentServletResolver rateLimitRuleArgumentResolver, @Nullable PolarisRateLimiterLimitedFallback polarisRateLimiterLimitedFallback) {
        this.limitAPI = limitAPI;
        this.polarisRateLimitProperties = polarisRateLimitProperties;
        this.rateLimitRuleArgumentResolver = rateLimitRuleArgumentResolver;
        this.polarisRateLimiterLimitedFallback = polarisRateLimiterLimitedFallback;
    }

    @PostConstruct
    public void init() {
        this.rejectTips = RateLimitUtils.getRejectTips(this.polarisRateLimitProperties);
    }

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        String localNamespace = MetadataContext.LOCAL_NAMESPACE;
        String localService = MetadataContext.LOCAL_SERVICE;
        Set<Argument> arguments = this.rateLimitRuleArgumentResolver.getArguments(request, localNamespace, localService);
        try {
            QuotaResponse quotaResponse = QuotaCheckUtils.getQuota(this.limitAPI, localNamespace, localService, 1, arguments, request.getRequestURI());
            if (quotaResponse.getCode() == QuotaResultCode.QuotaResultLimited) {
                if (!Objects.isNull(this.polarisRateLimiterLimitedFallback)) {
                    response.setStatus(this.polarisRateLimiterLimitedFallback.rejectHttpCode().intValue());
                    String contentType = new MediaType(this.polarisRateLimiterLimitedFallback.mediaType(), this.polarisRateLimiterLimitedFallback.charset()).toString();
                    response.setContentType(contentType);
                    response.getWriter().write(this.polarisRateLimiterLimitedFallback.rejectTips());
                } else {
                    response.setStatus(this.polarisRateLimitProperties.getRejectHttpCode());
                    response.setContentType("text/html;charset=UTF-8");
                    response.getWriter().write(this.rejectTips);
                }
                response.addHeader("internal-callee-retstatus", RetStatus.RetFlowControl.getDesc());
                if (Objects.nonNull(quotaResponse.getActiveRule())) {
                    response.addHeader("internal-callee-activerule", quotaResponse.getActiveRule().getName().getValue());
                }
                return;
            }
            if (quotaResponse.getCode() == QuotaResultCode.QuotaResultOk && quotaResponse.getWaitMs() > 0L) {
                LOG.debug("The request of [{}] will waiting for {}ms.", (Object)request.getRequestURI(), (Object)quotaResponse.getWaitMs());
                Thread.sleep(quotaResponse.getWaitMs());
            }
        }
        catch (Throwable t) {
            LOG.error("fail to invoke getQuota, service is " + localService, t);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

