/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.ratelimit.resolver;

import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.polaris.context.ServiceRuleManager;
import com.tencent.cloud.polaris.ratelimit.spi.PolarisRateLimiterLabelReactiveResolver;
import com.tencent.polaris.ratelimit.api.rpc.Argument;
import com.tencent.polaris.specification.api.v1.traffic.manage.RateLimitProto;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;

public class RateLimitRuleArgumentReactiveResolver {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimitRuleArgumentReactiveResolver.class);
    private final ServiceRuleManager serviceRuleManager;
    private final PolarisRateLimiterLabelReactiveResolver labelResolver;

    public RateLimitRuleArgumentReactiveResolver(ServiceRuleManager serviceRuleManager, PolarisRateLimiterLabelReactiveResolver labelResolver) {
        this.serviceRuleManager = serviceRuleManager;
        this.labelResolver = labelResolver;
    }

    public Set<Argument> getArguments(ServerWebExchange request, String namespace, String service) {
        RateLimitProto.RateLimit rateLimitRule = this.serviceRuleManager.getServiceRateLimitRule(namespace, service);
        if (rateLimitRule == null) {
            return Collections.emptySet();
        }
        List rules = rateLimitRule.getRulesList();
        if (CollectionUtils.isEmpty((Collection)rules)) {
            return Collections.emptySet();
        }
        return rules.stream().flatMap(rule -> rule.getArgumentsList().stream()).map(matchArgument -> {
            String matchKey = matchArgument.getKey();
            Argument argument = null;
            switch (matchArgument.getType()) {
                case CUSTOM: {
                    argument = StringUtils.isBlank((String)matchKey) ? null : Argument.buildCustom((String)matchKey, (String)Optional.ofNullable(this.getCustomResolvedLabels(request).get(matchKey)).orElse(""));
                    break;
                }
                case METHOD: {
                    argument = Argument.buildMethod((String)request.getRequest().getMethodValue());
                    break;
                }
                case HEADER: {
                    argument = StringUtils.isBlank((String)matchKey) ? null : Argument.buildHeader((String)matchKey, (String)Optional.ofNullable(request.getRequest().getHeaders().getFirst(matchKey)).orElse(""));
                    break;
                }
                case QUERY: {
                    argument = StringUtils.isBlank((String)matchKey) ? null : Argument.buildQuery((String)matchKey, (String)Optional.ofNullable((String)request.getRequest().getQueryParams().getFirst((Object)matchKey)).orElse(""));
                    break;
                }
                case CALLER_SERVICE: {
                    String sourceServiceNamespace = MetadataContextHolder.getDisposableMetadata((String)"source_service_namespace", (boolean)true).orElse("");
                    String sourceServiceName = MetadataContextHolder.getDisposableMetadata((String)"source_service_name", (boolean)true).orElse("");
                    if (StringUtils.isEmpty((String)sourceServiceNamespace) || StringUtils.isEmpty((String)sourceServiceName)) break;
                    argument = Argument.buildCallerService((String)sourceServiceNamespace, (String)sourceServiceName);
                    break;
                }
                case CALLER_IP: {
                    InetSocketAddress remoteAddress = request.getRequest().getRemoteAddress();
                    argument = Argument.buildCallerIP((String)(remoteAddress != null ? remoteAddress.getAddress().getHostAddress() : ""));
                    break;
                }
            }
            return argument;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Map<String, String> getCustomResolvedLabels(ServerWebExchange request) {
        if (this.labelResolver != null) {
            try {
                return this.labelResolver.resolve(request);
            }
            catch (Throwable e) {
                LOG.error("resolve custom label failed. resolver = {}", (Object)this.labelResolver.getClass().getName(), (Object)e);
            }
        }
        return Collections.emptyMap();
    }
}

