/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.ratelimit.resolver;

import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.polaris.context.ServiceRuleManager;
import com.tencent.cloud.polaris.ratelimit.filter.QuotaCheckServletFilter;
import com.tencent.cloud.polaris.ratelimit.spi.PolarisRateLimiterLabelServletResolver;
import com.tencent.polaris.ratelimit.api.rpc.Argument;
import com.tencent.polaris.specification.api.v1.traffic.manage.RateLimitProto;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RateLimitRuleArgumentServletResolver {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaCheckServletFilter.class);
    private final ServiceRuleManager serviceRuleManager;
    private final PolarisRateLimiterLabelServletResolver labelResolver;

    public RateLimitRuleArgumentServletResolver(ServiceRuleManager serviceRuleManager, PolarisRateLimiterLabelServletResolver labelResolver) {
        this.serviceRuleManager = serviceRuleManager;
        this.labelResolver = labelResolver;
    }

    public Set<Argument> getArguments(HttpServletRequest request, String namespace, String service) {
        RateLimitProto.RateLimit rateLimitRule = this.serviceRuleManager.getServiceRateLimitRule(namespace, service);
        if (rateLimitRule == null) {
            return Collections.emptySet();
        }
        List rules = rateLimitRule.getRulesList();
        if (CollectionUtils.isEmpty((Collection)rules)) {
            return Collections.emptySet();
        }
        return rules.stream().flatMap(rule -> rule.getArgumentsList().stream()).map(matchArgument -> {
            String matchKey = matchArgument.getKey();
            Argument argument = null;
            switch (matchArgument.getType()) {
                case CUSTOM: {
                    argument = StringUtils.isBlank((String)matchKey) ? null : Argument.buildCustom((String)matchKey, (String)Optional.ofNullable(this.getCustomResolvedLabels(request).get(matchKey)).orElse(""));
                    break;
                }
                case METHOD: {
                    argument = Argument.buildMethod((String)request.getMethod());
                    break;
                }
                case HEADER: {
                    argument = StringUtils.isBlank((String)matchKey) ? null : Argument.buildHeader((String)matchKey, (String)Optional.ofNullable(request.getHeader(matchKey)).orElse(""));
                    break;
                }
                case QUERY: {
                    argument = StringUtils.isBlank((String)matchKey) ? null : Argument.buildQuery((String)matchKey, (String)Optional.ofNullable(request.getParameter(matchKey)).orElse(""));
                    break;
                }
                case CALLER_SERVICE: {
                    String sourceServiceNamespace = MetadataContextHolder.getDisposableMetadata((String)"source_service_namespace", (boolean)true).orElse("");
                    String sourceServiceName = MetadataContextHolder.getDisposableMetadata((String)"source_service_name", (boolean)true).orElse("");
                    if (StringUtils.isEmpty((String)sourceServiceNamespace) || StringUtils.isEmpty((String)sourceServiceName)) break;
                    argument = Argument.buildCallerService((String)sourceServiceNamespace, (String)sourceServiceName);
                    break;
                }
                case CALLER_IP: {
                    argument = Argument.buildCallerIP((String)Optional.ofNullable(request.getRemoteAddr()).orElse(""));
                    break;
                }
            }
            return argument;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Map<String, String> getCustomResolvedLabels(HttpServletRequest request) {
        if (this.labelResolver != null) {
            try {
                return this.labelResolver.resolve(request);
            }
            catch (Throwable e) {
                LOG.error("resolve custom label failed. resolver = {}", (Object)this.labelResolver.getClass().getName(), (Object)e);
            }
        }
        return Collections.emptyMap();
    }
}

