/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.ratelimit.utils;

import com.tencent.cloud.common.util.ResourceFileUtils;
import com.tencent.cloud.polaris.ratelimit.config.PolarisRateLimitProperties;
import com.tencent.cloud.polaris.ratelimit.constant.RateLimitConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class RateLimitUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimitUtils.class);

    private RateLimitUtils() {
    }

    public static String getRejectTips(PolarisRateLimitProperties polarisRateLimitProperties) {
        String tips = polarisRateLimitProperties.getRejectRequestTips();
        if (StringUtils.hasText((String)tips)) {
            return tips;
        }
        String rejectFilePath = polarisRateLimitProperties.getRejectRequestTipsFilePath();
        if (StringUtils.hasText((String)rejectFilePath)) {
            try {
                tips = ResourceFileUtils.readFile((String)rejectFilePath);
            }
            catch (Exception e) {
                LOG.error("[RateLimit] Read custom reject tips file error. path = {}", (Object)rejectFilePath, (Object)e);
            }
        }
        if (StringUtils.hasText((String)tips)) {
            return tips;
        }
        return RateLimitConstant.QUOTA_LIMITED_INFO;
    }
}

