/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.metadata;

import com.tencent.cloud.common.metadata.config.MetadataLocalProperties;
import com.tencent.cloud.common.spi.InstanceMetadataProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class StaticMetadataManager {
    public static final String LOCATION_KEY_REGION = "region";
    public static final String LOCATION_KEY_ZONE = "zone";
    public static final String LOCATION_KEY_CAMPUS = "campus";
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticMetadataManager.class);
    private static final String ENV_METADATA_PREFIX = "SCT_METADATA_CONTENT_";
    private static final int ENV_METADATA_PREFIX_LENGTH = "SCT_METADATA_CONTENT_".length();
    private static final String ENV_METADATA_CONTENT_TRANSITIVE = "SCT_METADATA_CONTENT_TRANSITIVE";
    private static final String ENV_METADATA_CONTENT_DISPOSABLE = "SCT_METADATA_CONTENT_DISPOSABLE";
    private static final String ENV_TRAFFIC_CONTENT_RAW_TRANSHEADERS = "SCT_TRAFFIC_CONTENT_RAW_TRANSHEADERS";
    private static final String ENV_METADATA_ZONE = "SCT_METADATA_ZONE";
    private static final String ENV_METADATA_REGION = "SCT_METADATA_REGION";
    private static final String ENV_METADATA_CAMPUS = "SCT_METADATA_CAMPUS";
    private Map<String, String> envMetadata;
    private Map<String, String> envTransitiveMetadata;
    private Map<String, String> envDisposableMetadata;
    private Map<String, String> envNotReportMetadata;
    private Map<String, String> configMetadata;
    private Map<String, String> configTransitiveMetadata;
    private Map<String, String> configDisposableMetadata;
    private Map<String, String> customSPIMetadata;
    private Map<String, String> customSPITransitiveMetadata;
    private Map<String, String> customSPIDisposableMetadata;
    private Map<String, String> mergedStaticMetadata;
    private Map<String, String> mergedStaticTransitiveMetadata;
    private Map<String, String> mergedStaticDisposableMetadata;
    private String region;
    private String zone;
    private String campus;

    public StaticMetadataManager(MetadataLocalProperties metadataLocalProperties, List<InstanceMetadataProvider> instanceMetadataProviders) {
        this.parseConfigMetadata(metadataLocalProperties);
        this.parseEnvMetadata();
        this.parseCustomMetadata(instanceMetadataProviders);
        this.parseLocationMetadata(metadataLocalProperties, instanceMetadataProviders);
        this.merge();
        LOGGER.info("[SCT] Loaded static metadata info. {}", (Object)this);
    }

    private void parseEnvMetadata() {
        String[] keyArr;
        String[] keyArr2;
        Map<String, String> allEnvs = System.getenv();
        this.envMetadata = new HashMap<String, String>();
        this.envNotReportMetadata = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : allEnvs.entrySet()) {
            String[] key = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.isNotBlank((String)key) || !key.startsWith(ENV_METADATA_PREFIX) && !key.equals(ENV_TRAFFIC_CONTENT_RAW_TRANSHEADERS) || key.equals(ENV_METADATA_CONTENT_TRANSITIVE) || key.equals(ENV_METADATA_CONTENT_DISPOSABLE)) continue;
            Object sourceKey = "";
            if (key.equals(ENV_TRAFFIC_CONTENT_RAW_TRANSHEADERS)) {
                sourceKey = key;
                this.envNotReportMetadata.put((String)sourceKey, value);
            } else {
                sourceKey = StringUtils.substring((String)key, (int)ENV_METADATA_PREFIX_LENGTH);
                this.envMetadata.put((String)sourceKey, value);
            }
            LOGGER.info("[SCT] resolve metadata from env. key = {}, value = {}", sourceKey, (Object)value);
        }
        this.envMetadata = Collections.unmodifiableMap(this.envMetadata);
        this.envTransitiveMetadata = new HashMap<String, String>();
        String transitiveKeys = allEnvs.get(ENV_METADATA_CONTENT_TRANSITIVE);
        if (StringUtils.isNotBlank((String)transitiveKeys) && (keyArr2 = StringUtils.split((String)transitiveKeys, (String)",")) != null && keyArr2.length > 0) {
            for (String key : keyArr2) {
                String value = this.envMetadata.get(key);
                if (!StringUtils.isNotBlank((String)value)) continue;
                this.envTransitiveMetadata.put(key, value);
            }
        }
        this.envTransitiveMetadata = Collections.unmodifiableMap(this.envTransitiveMetadata);
        this.envDisposableMetadata = new HashMap<String, String>();
        String disposableKeys = allEnvs.get(ENV_METADATA_CONTENT_DISPOSABLE);
        if (StringUtils.isNotBlank((String)disposableKeys) && (keyArr = StringUtils.split((String)disposableKeys, (String)",")) != null && keyArr.length > 0) {
            for (String key : keyArr) {
                String value = this.envMetadata.get(key);
                if (!StringUtils.isNotBlank((String)value)) continue;
                this.envDisposableMetadata.put(key, value);
            }
        }
        this.envDisposableMetadata = Collections.unmodifiableMap(this.envDisposableMetadata);
    }

    private void parseConfigMetadata(MetadataLocalProperties metadataLocalProperties) {
        Map<String, String> allMetadata = metadataLocalProperties.getContent();
        List<String> transitiveKeys = metadataLocalProperties.getTransitive();
        List<String> disposableKeys = metadataLocalProperties.getDisposable();
        HashMap<String, String> transitiveResult = new HashMap<String, String>();
        for (String key : transitiveKeys) {
            if (!allMetadata.containsKey(key)) continue;
            transitiveResult.put(key, allMetadata.get(key));
        }
        HashMap<String, String> disposableResult = new HashMap<String, String>();
        for (String key : disposableKeys) {
            if (!allMetadata.containsKey(key)) continue;
            disposableResult.put(key, allMetadata.get(key));
        }
        this.configTransitiveMetadata = Collections.unmodifiableMap(transitiveResult);
        this.configDisposableMetadata = Collections.unmodifiableMap(disposableResult);
        this.configMetadata = Collections.unmodifiableMap(allMetadata);
    }

    private void parseCustomMetadata(List<InstanceMetadataProvider> instanceMetadataProviders) {
        this.customSPIMetadata = new HashMap<String, String>();
        this.customSPITransitiveMetadata = new HashMap<String, String>();
        this.customSPIDisposableMetadata = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(instanceMetadataProviders)) {
            instanceMetadataProviders.forEach(this::parseCustomMetadata);
        }
        this.customSPIMetadata = Collections.unmodifiableMap(this.customSPIMetadata);
        this.customSPITransitiveMetadata = Collections.unmodifiableMap(this.customSPITransitiveMetadata);
        this.customSPIDisposableMetadata = Collections.unmodifiableMap(this.customSPIDisposableMetadata);
    }

    private void parseCustomMetadata(InstanceMetadataProvider instanceMetadataProvider) {
        Map<String, String> allMetadata = instanceMetadataProvider.getMetadata();
        if (!CollectionUtils.isEmpty(allMetadata)) {
            this.customSPIMetadata.putAll(allMetadata);
        }
        Set<String> transitiveKeys = instanceMetadataProvider.getTransitiveMetadataKeys();
        HashMap<String, String> transitiveMetadata = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(transitiveKeys)) {
            for (String key : transitiveKeys) {
                if (!this.customSPIMetadata.containsKey(key)) continue;
                transitiveMetadata.put(key, this.customSPIMetadata.get(key));
            }
        }
        this.customSPITransitiveMetadata.putAll(transitiveMetadata);
        Set<String> disposableKeys = instanceMetadataProvider.getDisposableMetadataKeys();
        HashMap<String, String> disposableMetadata = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(disposableKeys)) {
            for (String key : disposableKeys) {
                if (!this.customSPIMetadata.containsKey(key)) continue;
                disposableMetadata.put(key, this.customSPIMetadata.get(key));
            }
        }
        this.customSPIDisposableMetadata.putAll(disposableMetadata);
    }

    private void merge() {
        HashMap<String, String> mergedMetadataResult = new HashMap<String, String>();
        mergedMetadataResult.putAll(this.configMetadata);
        mergedMetadataResult.putAll(this.envMetadata);
        mergedMetadataResult.putAll(this.customSPIMetadata);
        this.mergedStaticMetadata = Collections.unmodifiableMap(mergedMetadataResult);
        HashMap<String, String> mergedTransitiveMetadataResult = new HashMap<String, String>();
        mergedTransitiveMetadataResult.putAll(this.configTransitiveMetadata);
        mergedTransitiveMetadataResult.putAll(this.envTransitiveMetadata);
        mergedTransitiveMetadataResult.putAll(this.customSPITransitiveMetadata);
        this.mergedStaticTransitiveMetadata = Collections.unmodifiableMap(mergedTransitiveMetadataResult);
        HashMap<String, String> mergedDisposableMetadataResult = new HashMap<String, String>();
        mergedDisposableMetadataResult.putAll(this.configDisposableMetadata);
        mergedDisposableMetadataResult.putAll(this.envDisposableMetadata);
        mergedDisposableMetadataResult.putAll(this.customSPIDisposableMetadata);
        this.mergedStaticDisposableMetadata = Collections.unmodifiableMap(mergedDisposableMetadataResult);
    }

    private void parseLocationMetadata(MetadataLocalProperties metadataLocalProperties, List<InstanceMetadataProvider> instanceMetadataProviders) {
        Set providerCampus;
        Set providerZones;
        Set providerRegions;
        if (!CollectionUtils.isEmpty(instanceMetadataProviders) && !CollectionUtils.isEmpty(providerRegions = instanceMetadataProviders.stream().map(InstanceMetadataProvider::getRegion).filter(region -> !StringUtils.isBlank((String)region)).collect(Collectors.toSet()))) {
            if (providerRegions.size() > 1) {
                throw new IllegalArgumentException("Multiple Regions Provided in InstanceMetadataProviders");
            }
            this.region = (String)providerRegions.iterator().next();
        }
        if (StringUtils.isBlank((String)this.region)) {
            this.region = System.getenv(ENV_METADATA_REGION);
        }
        if (StringUtils.isBlank((String)this.region)) {
            this.region = metadataLocalProperties.getContent().get(LOCATION_KEY_REGION);
        }
        if (!CollectionUtils.isEmpty(instanceMetadataProviders) && !CollectionUtils.isEmpty(providerZones = instanceMetadataProviders.stream().map(InstanceMetadataProvider::getZone).filter(zone -> !StringUtils.isBlank((String)zone)).collect(Collectors.toSet()))) {
            if (providerZones.size() > 1) {
                throw new IllegalArgumentException("Multiple Zones Provided in InstanceMetadataProviders");
            }
            this.zone = (String)providerZones.iterator().next();
        }
        if (StringUtils.isBlank((String)this.zone)) {
            this.zone = System.getenv(ENV_METADATA_ZONE);
        }
        if (StringUtils.isBlank((String)this.zone)) {
            this.zone = metadataLocalProperties.getContent().get(LOCATION_KEY_ZONE);
        }
        if (!CollectionUtils.isEmpty(instanceMetadataProviders) && !CollectionUtils.isEmpty(providerCampus = instanceMetadataProviders.stream().map(InstanceMetadataProvider::getCampus).filter(campus -> !StringUtils.isBlank((String)campus)).collect(Collectors.toSet()))) {
            if (providerCampus.size() > 1) {
                throw new IllegalArgumentException("Multiple Campus Provided in InstanceMetadataProviders");
            }
            this.campus = (String)providerCampus.iterator().next();
        }
        if (StringUtils.isBlank((String)this.campus)) {
            this.campus = System.getenv(ENV_METADATA_CAMPUS);
        }
        if (StringUtils.isBlank((String)this.campus)) {
            this.campus = metadataLocalProperties.getContent().get(LOCATION_KEY_CAMPUS);
        }
    }

    public Map<String, String> getAllEnvMetadata() {
        return this.envMetadata;
    }

    public String getTransHeaderFromEnv() {
        return this.envNotReportMetadata.get(ENV_TRAFFIC_CONTENT_RAW_TRANSHEADERS);
    }

    public Map<String, String> getEnvTransitiveMetadata() {
        return this.envTransitiveMetadata;
    }

    public Map<String, String> getEnvDisposableMetadata() {
        return this.envDisposableMetadata;
    }

    public Map<String, String> getAllConfigMetadata() {
        return this.configMetadata;
    }

    public Map<String, String> getConfigTransitiveMetadata() {
        return this.configTransitiveMetadata;
    }

    public Map<String, String> getConfigDisposableMetadata() {
        return this.configDisposableMetadata;
    }

    public Map<String, String> getAllCustomMetadata() {
        return this.customSPIMetadata;
    }

    public Map<String, String> getCustomSPITransitiveMetadata() {
        return this.customSPITransitiveMetadata;
    }

    public Map<String, String> getCustomSPIDisposableMetadata() {
        return this.customSPIDisposableMetadata;
    }

    public Map<String, String> getMergedStaticMetadata() {
        return this.mergedStaticMetadata;
    }

    public Map<String, String> getMergedStaticTransitiveMetadata() {
        return this.mergedStaticTransitiveMetadata;
    }

    public Map<String, String> getMergedStaticDisposableMetadata() {
        return this.mergedStaticDisposableMetadata;
    }

    public String getZone() {
        return this.zone;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCampus() {
        return this.campus;
    }

    public Map<String, String> getLocationMetadata() {
        HashMap<String, String> locationMetadata = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.region)) {
            locationMetadata.put(LOCATION_KEY_REGION, this.region);
        }
        if (StringUtils.isNotBlank((String)this.zone)) {
            locationMetadata.put(LOCATION_KEY_ZONE, this.zone);
        }
        if (StringUtils.isNotBlank((String)this.campus)) {
            locationMetadata.put(LOCATION_KEY_CAMPUS, this.campus);
        }
        return locationMetadata;
    }

    public String toString() {
        return "StaticMetadataManager{envMetadata=" + this.envMetadata + ", envTransitiveMetadata=" + this.envTransitiveMetadata + ", configMetadata=" + this.configMetadata + ", configTransitiveMetadata=" + this.configTransitiveMetadata + ", customSPIMetadata=" + this.customSPIMetadata + ", customSPITransitiveMetadata=" + this.customSPITransitiveMetadata + ", mergedStaticMetadata=" + this.mergedStaticMetadata + ", mergedStaticTransitiveMetadata=" + this.mergedStaticTransitiveMetadata + ", zone='" + this.zone + "', region='" + this.region + "', campus='" + this.campus + "'}";
    }
}

