/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.metadata.endpoint;

import com.tencent.cloud.common.metadata.StaticMetadataManager;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="polaris-metadata")
public class PolarisMetadataEndpoint {
    private final StaticMetadataManager staticMetadataManager;

    public PolarisMetadataEndpoint(StaticMetadataManager staticMetadataManager) {
        this.staticMetadataManager = staticMetadataManager;
    }

    @ReadOperation
    public Map<String, Object> metadata() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Env", this.staticMetadataManager.getAllEnvMetadata());
        result.put("EnvTransitive", this.staticMetadataManager.getEnvTransitiveMetadata());
        result.put("ConfigTransitive", this.staticMetadataManager.getConfigTransitiveMetadata());
        result.put("ConfigDisposable", this.staticMetadataManager.getConfigDisposableMetadata());
        result.put("Config", this.staticMetadataManager.getAllConfigMetadata());
        result.put("MergeStatic", this.staticMetadataManager.getMergedStaticMetadata());
        result.put("MergeStaticTransitive", this.staticMetadataManager.getMergedStaticTransitiveMetadata());
        result.put("MergeStaticDisposable", this.staticMetadataManager.getMergedStaticDisposableMetadata());
        result.put("CustomSPI", this.staticMetadataManager.getAllCustomMetadata());
        result.put("CustomSPITransitive", this.staticMetadataManager.getCustomSPITransitiveMetadata());
        result.put("CustomSPIDisposable", this.staticMetadataManager.getCustomSPIDisposableMetadata());
        result.put("zone", this.staticMetadataManager.getZone());
        result.put("region", this.staticMetadataManager.getRegion());
        result.put("campus", this.staticMetadataManager.getCampus());
        return result;
    }
}

