/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.pojo;

import com.tencent.polaris.api.pojo.Instance;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;

public class PolarisServiceInstance
implements ServiceInstance {
    private final Instance instance;
    private final boolean isSecure;
    private final String scheme;

    public PolarisServiceInstance(Instance instance) {
        this.instance = instance;
        this.isSecure = StringUtils.equalsIgnoreCase((String)instance.getProtocol(), (String)"https");
        this.scheme = this.isSecure ? "https" : "http";
    }

    public Instance getPolarisInstance() {
        return this.instance;
    }

    public String getInstanceId() {
        return this.instance.getId();
    }

    public String getServiceId() {
        return this.instance.getService();
    }

    public String getHost() {
        return this.instance.getHost();
    }

    public int getPort() {
        return this.instance.getPort();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        return this.instance.getMetadata();
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolarisServiceInstance that = (PolarisServiceInstance)o;
        return Objects.equals(this.instance, that.instance) && Objects.equals(this.scheme, that.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.instance, this.scheme);
    }
}

