/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.rule;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public enum Operation {
    EQUALS("EQUALS"),
    NOT_EQUALS("NOT_EQUALS"),
    IN("IN"),
    NOT_IN("NOT_IN"),
    REGEX("REGEX"),
    BLANK("BLANK"),
    NOT_BLANK("NOT_BLANK");

    private final String value;

    private Operation(String value) {
        this.value = value;
    }

    public static boolean match(List<String> expectedValues, String actualValue, String rawOperation) {
        String firstExpectedValue = null;
        if (!CollectionUtils.isEmpty(expectedValues)) {
            firstExpectedValue = expectedValues.get(0);
        }
        switch (Operation.getOperation(rawOperation)) {
            case EQUALS: {
                return firstExpectedValue != null && StringUtils.equals((String)actualValue, (String)firstExpectedValue);
            }
            case NOT_EQUALS: {
                return firstExpectedValue == null || !StringUtils.equals((String)actualValue, (String)firstExpectedValue);
            }
            case BLANK: {
                return StringUtils.isBlank((String)actualValue);
            }
            case NOT_BLANK: {
                return !StringUtils.isBlank((String)actualValue);
            }
            case IN: {
                if (CollectionUtils.isEmpty(expectedValues)) {
                    return false;
                }
                return expectedValues.contains(actualValue);
            }
            case NOT_IN: {
                if (CollectionUtils.isEmpty(expectedValues)) {
                    return true;
                }
                return !expectedValues.contains(actualValue);
            }
            case REGEX: {
                if (firstExpectedValue == null) {
                    return false;
                }
                Pattern r = Pattern.compile(firstExpectedValue);
                return r.matcher(actualValue).matches();
            }
        }
        return false;
    }

    public static Operation getOperation(String operation) {
        if (StringUtils.equalsIgnoreCase((String)operation, (String)Operation.EQUALS.value)) {
            return EQUALS;
        }
        if (StringUtils.equalsIgnoreCase((String)operation, (String)Operation.NOT_EQUALS.value)) {
            return NOT_EQUALS;
        }
        if (StringUtils.equalsIgnoreCase((String)operation, (String)Operation.IN.value)) {
            return IN;
        }
        if (StringUtils.equalsIgnoreCase((String)operation, (String)Operation.NOT_IN.value)) {
            return NOT_IN;
        }
        if (StringUtils.equalsIgnoreCase((String)operation, (String)Operation.REGEX.value)) {
            return REGEX;
        }
        if (StringUtils.equalsIgnoreCase((String)operation, (String)Operation.BLANK.value)) {
            return BLANK;
        }
        if (StringUtils.equalsIgnoreCase((String)operation, (String)Operation.NOT_BLANK.value)) {
            return NOT_BLANK;
        }
        throw new RuntimeException("Unsupported operation. operation = " + operation);
    }

    public String getValue() {
        return this.value;
    }
}

