/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util.expresstion;

import com.tencent.cloud.common.util.expresstion.ExpressionParser;
import org.apache.commons.lang.StringUtils;

public class ExpressionParserV1
implements ExpressionParser {
    private static final String LABEL_HEADER_PREFIX = "${http.header.";
    private static final int LABEL_HEADER_PREFIX_LEN = "${http.header.".length();
    private static final String LABEL_QUERY_PREFIX = "${http.query.";
    private static final int LABEL_QUERY_PREFIX_LEN = "${http.query.".length();
    private static final String LABEL_COOKIE_PREFIX = "${http.cookie.";
    private static final int LABEL_COOKIE_PREFIX_LEN = "${http.cookie.".length();
    private static final String LABEL_METHOD = "${http.method}";
    private static final String LABEL_URI = "${http.uri}";
    private static final String LABEL_CALLER_IP = "${http.caller.ip}";
    private static final String LABEL_PREFIX = "${";
    private static final String LABEL_SUFFIX = "}";

    @Override
    public boolean isExpressionLabel(String labelKey) {
        if (StringUtils.isEmpty((String)labelKey)) {
            return false;
        }
        return StringUtils.startsWith((String)labelKey, (String)LABEL_PREFIX) && StringUtils.endsWith((String)labelKey, (String)LABEL_SUFFIX);
    }

    @Override
    public boolean isHeaderLabel(String expression) {
        return StringUtils.startsWith((String)expression, (String)LABEL_HEADER_PREFIX) && StringUtils.endsWith((String)expression, (String)LABEL_SUFFIX);
    }

    @Override
    public String parseHeaderKey(String expression) {
        return StringUtils.substring((String)expression, (int)LABEL_HEADER_PREFIX_LEN, (int)(expression.length() - 1));
    }

    @Override
    public boolean isQueryLabel(String expression) {
        return StringUtils.startsWith((String)expression, (String)LABEL_QUERY_PREFIX) && StringUtils.endsWith((String)expression, (String)LABEL_SUFFIX);
    }

    @Override
    public String parseQueryKey(String expression) {
        return StringUtils.substring((String)expression, (int)LABEL_QUERY_PREFIX_LEN, (int)(expression.length() - 1));
    }

    @Override
    public boolean isCookieLabel(String expression) {
        return StringUtils.startsWith((String)expression, (String)LABEL_COOKIE_PREFIX) && StringUtils.endsWith((String)expression, (String)LABEL_SUFFIX);
    }

    @Override
    public String parseCookieKey(String expression) {
        return StringUtils.substring((String)expression, (int)LABEL_COOKIE_PREFIX_LEN, (int)(expression.length() - 1));
    }

    @Override
    public boolean isMethodLabel(String expression) {
        return StringUtils.equalsIgnoreCase((String)expression, (String)LABEL_METHOD);
    }

    @Override
    public boolean isUriLabel(String expression) {
        return StringUtils.equalsIgnoreCase((String)expression, (String)LABEL_URI);
    }

    @Override
    public boolean isCallerIPLabel(String expression) {
        return StringUtils.equalsIgnoreCase((String)expression, (String)LABEL_CALLER_IP);
    }
}

