/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util.expresstion;

import com.tencent.cloud.common.util.expresstion.ExpressionLabelUtils;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public final class ServletExpressionLabelUtils {
    private ServletExpressionLabelUtils() {
    }

    public static Map<String, String> resolve(HttpServletRequest request, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String labelKey : labelKeys) {
            if (!ExpressionLabelUtils.isExpressionLabel(labelKey)) continue;
            if (ExpressionLabelUtils.isHeaderLabel(labelKey)) {
                String headerKey = ExpressionLabelUtils.parseHeaderKey(labelKey);
                if (StringUtils.isBlank((String)headerKey)) continue;
                labels.put(labelKey, request.getHeader(headerKey));
                continue;
            }
            if (ExpressionLabelUtils.isQueryLabel(labelKey)) {
                String queryKey = ExpressionLabelUtils.parseQueryKey(labelKey);
                if (StringUtils.isBlank((String)queryKey)) continue;
                labels.put(labelKey, ExpressionLabelUtils.getQueryValue(request.getQueryString(), queryKey));
                continue;
            }
            if (ExpressionLabelUtils.isCookieLabel(labelKey)) {
                String cookieKey = ExpressionLabelUtils.parseCookieKey(labelKey);
                if (StringUtils.isBlank((String)cookieKey)) continue;
                labels.put(labelKey, ServletExpressionLabelUtils.getCookieValue(request.getCookies(), cookieKey));
                continue;
            }
            if (ExpressionLabelUtils.isMethodLabel(labelKey)) {
                labels.put(labelKey, request.getMethod());
                continue;
            }
            if (!ExpressionLabelUtils.isUriLabel(labelKey)) continue;
            labels.put(labelKey, request.getRequestURI());
        }
        return labels;
    }

    public static String getCookieValue(Cookie[] cookies, String key) {
        if (cookies == null || cookies.length == 0) {
            return "";
        }
        for (Cookie cookie : cookies) {
            if (!StringUtils.equals((String)cookie.getName(), (String)key)) continue;
            return cookie.getValue();
        }
        return "";
    }
}

