/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util.expresstion;

import com.tencent.cloud.common.util.expresstion.ExpressionLabelUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public final class SpringWebExpressionLabelUtils {
    private SpringWebExpressionLabelUtils() {
    }

    public static Map<String, String> resolve(ServerWebExchange exchange, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String labelKey : labelKeys) {
            if (!ExpressionLabelUtils.isExpressionLabel(labelKey)) continue;
            if (ExpressionLabelUtils.isHeaderLabel(labelKey)) {
                String headerKey = ExpressionLabelUtils.parseHeaderKey(labelKey);
                if (StringUtils.isBlank((String)headerKey)) continue;
                labels.put(labelKey, SpringWebExpressionLabelUtils.getHeaderValue(exchange.getRequest(), headerKey));
                continue;
            }
            if (ExpressionLabelUtils.isQueryLabel(labelKey)) {
                String queryKey = ExpressionLabelUtils.parseQueryKey(labelKey);
                if (StringUtils.isBlank((String)queryKey)) continue;
                labels.put(labelKey, SpringWebExpressionLabelUtils.getQueryValue(exchange.getRequest(), queryKey));
                continue;
            }
            if (ExpressionLabelUtils.isCookieLabel(labelKey)) {
                String cookieKey = ExpressionLabelUtils.parseCookieKey(labelKey);
                if (StringUtils.isBlank((String)cookieKey)) continue;
                labels.put(labelKey, SpringWebExpressionLabelUtils.getCookieValue(exchange.getRequest(), cookieKey));
                continue;
            }
            if (ExpressionLabelUtils.isMethodLabel(labelKey)) {
                labels.put(labelKey, exchange.getRequest().getMethodValue());
                continue;
            }
            if (!ExpressionLabelUtils.isUriLabel(labelKey)) continue;
            labels.put(labelKey, exchange.getRequest().getURI().getPath());
        }
        return labels;
    }

    public static Map<String, String> resolve(HttpRequest request, Set<String> labelKeys) {
        if (CollectionUtils.isEmpty(labelKeys)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String labelKey : labelKeys) {
            if (!ExpressionLabelUtils.isExpressionLabel(labelKey)) continue;
            if (ExpressionLabelUtils.isHeaderLabel(labelKey)) {
                String headerKey = ExpressionLabelUtils.parseHeaderKey(labelKey);
                if (StringUtils.isBlank((String)headerKey)) continue;
                labels.put(labelKey, SpringWebExpressionLabelUtils.getHeaderValue(request, headerKey));
                continue;
            }
            if (ExpressionLabelUtils.isQueryLabel(labelKey)) {
                String queryKey = ExpressionLabelUtils.parseQueryKey(labelKey);
                if (StringUtils.isBlank((String)queryKey)) continue;
                labels.put(labelKey, SpringWebExpressionLabelUtils.getQueryValue(request, queryKey));
                continue;
            }
            if (ExpressionLabelUtils.isMethodLabel(labelKey)) {
                labels.put(labelKey, request.getMethodValue());
                continue;
            }
            if (!ExpressionLabelUtils.isUriLabel(labelKey)) continue;
            labels.put(labelKey, request.getURI().getPath());
        }
        return labels;
    }

    public static String getHeaderValue(ServerHttpRequest request, String key) {
        String value = request.getHeaders().getFirst(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String getQueryValue(ServerHttpRequest request, String key) {
        MultiValueMap queries = request.getQueryParams();
        if (CollectionUtils.isEmpty((Map)queries)) {
            return "";
        }
        String value = (String)queries.getFirst((Object)key);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String getCookieValue(ServerHttpRequest request, String key) {
        HttpCookie cookie = (HttpCookie)request.getCookies().getFirst((Object)key);
        if (cookie == null) {
            return "";
        }
        return cookie.getValue();
    }

    public static String getHeaderValue(HttpRequest request, String key) {
        HttpHeaders headers = request.getHeaders();
        return headers.getFirst(key);
    }

    public static String getQueryValue(HttpRequest request, String key) {
        String query = request.getURI().getQuery();
        return ExpressionLabelUtils.getQueryValue(query, key);
    }
}

