/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.webclient;

import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginRunner;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedResponseContext;
import java.util.Map;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class EnhancedWebClientReporter
implements ExchangeFilterFunction {
    private final EnhancedPluginRunner pluginRunner;

    public EnhancedWebClientReporter(EnhancedPluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        EnhancedPluginContext enhancedPluginContext = new EnhancedPluginContext();
        EnhancedRequestContext enhancedRequestContext = EnhancedRequestContext.builder().httpHeaders(request.headers()).httpMethod(request.method()).url(request.url()).build();
        enhancedPluginContext.setRequest(enhancedRequestContext);
        long startTime = System.currentTimeMillis();
        return next.exchange(request).doOnSubscribe(subscription -> {
            Map loadBalancerContext = MetadataContextHolder.get().getLoadbalancerMetadata();
            DefaultServiceInstance serviceInstance = new DefaultServiceInstance();
            serviceInstance.setServiceId((String)loadBalancerContext.get("internal-callee-serviceid"));
            serviceInstance.setHost(request.url().getHost());
            serviceInstance.setPort(request.url().getPort());
            enhancedPluginContext.setServiceInstance((ServiceInstance)serviceInstance);
        }).doOnSuccess(response -> {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startTime);
            EnhancedResponseContext enhancedResponseContext = EnhancedResponseContext.builder().httpStatus(response.rawStatusCode()).httpHeaders(response.headers().asHttpHeaders()).build();
            enhancedPluginContext.setResponse(enhancedResponseContext);
            this.pluginRunner.run(EnhancedPluginType.POST, enhancedPluginContext);
        }).doOnError(t -> {
            enhancedPluginContext.setDelay(System.currentTimeMillis() - startTime);
            enhancedPluginContext.setThrowable((Throwable)t);
            this.pluginRunner.run(EnhancedPluginType.EXCEPTION, enhancedPluginContext);
        }).doFinally(v -> this.pluginRunner.run(EnhancedPluginType.FINALLY, enhancedPluginContext));
    }
}

