/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.common;

import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.DefaultServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.pojo.Service;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.RuleUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSet;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSetLocator;
import com.tencent.polaris.plugins.circuitbreaker.common.RuleIdentifier;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class CircuitBreakUtils {
    private static final String matchAll = "*";

    public static boolean instanceHalfOpen(Instance instance, StatusDimension statusDimension) {
        CircuitBreakerStatus circuitBreakerStatus = instance.getCircuitBreakerStatus(statusDimension);
        if (null == circuitBreakerStatus) {
            return false;
        }
        return circuitBreakerStatus.getStatus() == CircuitBreakerStatus.Status.HALF_OPEN;
    }

    public static boolean instanceClose(Instance instance, StatusDimension statusDimension) {
        CircuitBreakerStatus circuitBreakerStatus = instance.getCircuitBreakerStatus(statusDimension);
        return null == circuitBreakerStatus || circuitBreakerStatus.getStatus() == CircuitBreakerStatus.Status.CLOSE;
    }

    private static CircuitBreakerProto.CircuitBreaker getCircuitBreakerRule(ServiceRule serviceRule) {
        if (null == serviceRule) {
            return null;
        }
        if (!serviceRule.isInitialized()) {
            return null;
        }
        return (CircuitBreakerProto.CircuitBreaker)serviceRule.getRule();
    }

    private static List<CircuitBreakerProto.CbRule> getRules(CircuitBreakerProto.CircuitBreaker dstRule, CircuitBreakerProto.CircuitBreaker srcRule) {
        if (null != dstRule && dstRule.getInboundsCount() > 0) {
            return dstRule.getInboundsList();
        }
        if (null != srcRule && srcRule.getOutboundsCount() > 0) {
            return srcRule.getOutboundsList();
        }
        return null;
    }

    private static MatchSourceResult matchSource(CircuitBreakerProto.CbRule rule, RuleIdentifier ruleIdentifier) {
        if (rule.getSourcesCount() == 0) {
            return new MatchSourceResult(true, true);
        }
        Service callerService = ruleIdentifier.getCallerService();
        for (CircuitBreakerProto.SourceMatcher sourceMatcher : rule.getSourcesList()) {
            boolean matchAllNamespace = sourceMatcher.getNamespace().getValue().equals(matchAll);
            boolean matchAllService = sourceMatcher.getService().getValue().equals(matchAll);
            if (matchAllNamespace && matchAllService) {
                return new MatchSourceResult(true, true);
            }
            if (null == callerService) continue;
            boolean namespaceMatch = matchAllNamespace;
            boolean serviceMatch = matchAllService;
            if (!namespaceMatch) {
                namespaceMatch = sourceMatcher.getNamespace().getValue().equals(callerService.getNamespace());
            }
            if (!serviceMatch) {
                serviceMatch = sourceMatcher.getService().getValue().equals(callerService.getService());
            }
            if (!namespaceMatch || !serviceMatch) continue;
            return new MatchSourceResult(true, false);
        }
        return new MatchSourceResult(false, false);
    }

    private static MatchDestResult matchDestination(CircuitBreakerProto.CbRule rule, RuleIdentifier ruleIdentifier, FlowCache flowCache) {
        if (rule.getDestinationsCount() == 0) {
            return new MatchDestResult(null, false);
        }
        for (CircuitBreakerProto.DestinationSet destinationSet : rule.getDestinationsList()) {
            boolean serviceMatch;
            String namespaceValue = destinationSet.getNamespace().getValue();
            String serviceValue = destinationSet.getService().getValue();
            boolean namespaceMatch = StringUtils.isBlank((String)namespaceValue) || namespaceValue.equals(matchAll);
            boolean bl = serviceMatch = StringUtils.isBlank((String)serviceValue) || serviceValue.equals(matchAll);
            if (!namespaceMatch) {
                namespaceMatch = namespaceValue.equals(ruleIdentifier.getNamespace());
            }
            if (!serviceMatch) {
                serviceMatch = serviceValue.equals(ruleIdentifier.getService());
            }
            if (!namespaceMatch || !serviceMatch) continue;
            ModelProto.MatchString methodMatcher = destinationSet.getMethod();
            if (null == methodMatcher) {
                return new MatchDestResult(destinationSet, true);
            }
            String methodMatcherValue = methodMatcher.getValue().getValue();
            if (StringUtils.isBlank((String)methodMatcherValue) || RuleUtils.isMatchAllValue((ModelProto.MatchString)methodMatcher)) {
                return new MatchDestResult(destinationSet, true);
            }
            String method = ruleIdentifier.getMethod();
            if (methodMatcher.getType() == ModelProto.MatchString.MatchStringType.EXACT && StringUtils.equals((String)methodMatcherValue, (String)method)) {
                return new MatchDestResult(destinationSet, false);
            }
            Pattern pattern = flowCache.loadOrStoreCompiledRegex(methodMatcherValue);
            if (!pattern.matcher(method).find()) continue;
            return new MatchDestResult(destinationSet, false);
        }
        return new MatchDestResult(null, false);
    }

    public static RuleDestinationResult getRuleDestinationSet(RuleIdentifier ruleIdentifier, Extensions extensions, FlowControlParam controlParam) {
        List<CircuitBreakerProto.CbRule> rules;
        HashSet<ServiceEventKey> svcEventKeys = new HashSet<ServiceEventKey>();
        ServiceEventKey dstSvcEventKey = new ServiceEventKey(new ServiceKey(ruleIdentifier.getNamespace(), ruleIdentifier.getService()), ServiceEventKey.EventType.CIRCUIT_BREAKING);
        svcEventKeys.add(dstSvcEventKey);
        ServiceEventKey srcSvcEventKey = null;
        Service callerService = ruleIdentifier.getCallerService();
        if (null != callerService && StringUtils.isNotBlank((String)callerService.getNamespace()) && StringUtils.isNotBlank((String)callerService.getService())) {
            srcSvcEventKey = new ServiceEventKey(new ServiceKey(callerService.getNamespace(), callerService.getService()), ServiceEventKey.EventType.CIRCUIT_BREAKING);
            svcEventKeys.add(srcSvcEventKey);
        }
        DefaultServiceEventKeysProvider serviceEventKeysProvider = new DefaultServiceEventKeysProvider();
        serviceEventKeysProvider.setSvcEventKeys(svcEventKeys);
        serviceEventKeysProvider.setUseCache(true);
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources((Extensions)extensions, (boolean)false, (ServiceEventKeysProvider)serviceEventKeysProvider, (FlowControlParam)controlParam);
        CircuitBreakerProto.CircuitBreaker dstRule = CircuitBreakUtils.getCircuitBreakerRule(resourcesResponse.getServiceRule(dstSvcEventKey));
        CircuitBreakerProto.CircuitBreaker srcRule = null;
        if (null != srcSvcEventKey) {
            srcRule = CircuitBreakUtils.getCircuitBreakerRule(resourcesResponse.getServiceRule(srcSvcEventKey));
        }
        if (CollectionUtils.isEmpty(rules = CircuitBreakUtils.getRules(dstRule, srcRule))) {
            return new RuleDestinationResult(null, false, false);
        }
        for (CircuitBreakerProto.CbRule rule : rules) {
            MatchSourceResult matchSourceResult = CircuitBreakUtils.matchSource(rule, ruleIdentifier);
            if (!matchSourceResult.matched) continue;
            MatchDestResult matchDestResult = CircuitBreakUtils.matchDestination(rule, ruleIdentifier, extensions.getFlowCache());
            if (null == matchDestResult.destinationSet) continue;
            return new RuleDestinationResult(matchDestResult.destinationSet, matchSourceResult.allSourcesMatched, matchDestResult.allMethod);
        }
        return new RuleDestinationResult(null, false, false);
    }

    public static <T extends Verifier> ConfigSet<T> getConfigSet(InstanceGauge gauge, ConfigSetLocator<T> locator) {
        RuleIdentifier ruleIdentifier = new RuleIdentifier(gauge.getNamespace(), gauge.getService(), gauge.getCallerService(), gauge.getMethod());
        return locator.getConfigSet(ruleIdentifier);
    }

    public static class RuleDestinationResult {
        private final CircuitBreakerProto.DestinationSet destinationSet;
        private final boolean matchAllSource;
        private final boolean matchAllMethod;

        public RuleDestinationResult(CircuitBreakerProto.DestinationSet destinationSet, boolean matchAllSource, boolean matchAllMethod) {
            this.destinationSet = destinationSet;
            this.matchAllSource = matchAllSource;
            this.matchAllMethod = matchAllMethod;
        }

        public CircuitBreakerProto.DestinationSet getDestinationSet() {
            return this.destinationSet;
        }

        public StatusDimension.Level getMatchLevel() {
            StatusDimension.Level level = this.matchAllSource && this.matchAllMethod ? StatusDimension.Level.SERVICE : (this.matchAllMethod ? StatusDimension.Level.ALL_METHOD : (this.matchAllSource ? StatusDimension.Level.ALL_CALLER : StatusDimension.Level.CALLER_METHOD));
            return level;
        }

        public static RuleDestinationResult defaultValue() {
            return new RuleDestinationResult(null, false, false);
        }
    }

    private static class MatchDestResult {
        final CircuitBreakerProto.DestinationSet destinationSet;
        final boolean allMethod;

        public MatchDestResult(CircuitBreakerProto.DestinationSet destinationSet, boolean allMethod) {
            this.destinationSet = destinationSet;
            this.allMethod = allMethod;
        }
    }

    private static class MatchSourceResult {
        final boolean matched;
        final boolean allSourcesMatched;

        public MatchSourceResult(boolean matched, boolean allSourcesMatched) {
            this.matched = matched;
            this.allSourcesMatched = allSourcesMatched;
        }
    }
}

