/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugin.location.remotehttp;

import com.google.protobuf.StringValue;
import com.tencent.polaris.api.plugin.location.LocationProvider;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugin.location.base.BaseLocationProvider;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class RemoteHttpLocationProvider
extends BaseLocationProvider<BaseLocationProvider.GetOption> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteHttpLocationProvider.class);

    public RemoteHttpLocationProvider() {
        super(BaseLocationProvider.GetOption.class);
    }

    public LocationProvider.ProviderType getProviderType() {
        return LocationProvider.ProviderType.REMOTE_HTTP;
    }

    public ModelProto.Location doGet(BaseLocationProvider.GetOption option) {
        String region = this.getResponse(option.getRegion(), "region");
        String zone = this.getResponse(option.getZone(), "zone");
        String campus = this.getResponse(option.getCampus(), "campus");
        if (StringUtils.isAllEmpty((String[])new String[]{region, zone, campus})) {
            return null;
        }
        LOGGER.info("[Location][Provider][RemoteHttp] get location from remote http : {}", (Object)option);
        return ModelProto.Location.newBuilder().setRegion(StringValue.newBuilder().setValue(region).build()).setZone(StringValue.newBuilder().setValue(zone).build()).setCampus(StringValue.newBuilder().setValue(campus).build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponse(String path, String label) {
        if (StringUtils.isEmpty((String)path)) {
            LOGGER.warn("[Location][Provider][RemoteHttp] get {} from remote url is empty", (Object)label);
            return "";
        }
        HttpURLConnection conn = null;
        try {
            String str;
            URL url = new URL(path);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            conn.setReadTimeout((int)TimeUnit.SECONDS.toMillis(2L));
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer buffer = new StringBuffer();
            while ((str = reader.readLine()) != null) {
                buffer.append(str);
            }
            if (conn.getResponseCode() != 200) {
                LOGGER.error("[Location][Provider][RemoteHttp] get {} from remote {} fail: {}", new Object[]{label, url, buffer});
                String string = "";
                return string;
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            LOGGER.error("[Location][Provider][RemoteHttp] get {} from remote {} fail : {}", new Object[]{label, path, e});
            String string = "";
            return string;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }
}

