/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.factory;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.circuitbreak.client.api.DefaultCircuitBreakAPI;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.factory.ConfigAPIFactory;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.Arrays;
import org.slf4j.Logger;

public class CircuitBreakAPIFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CircuitBreakAPIFactory.class);

    public static CircuitBreakAPI createCircuitBreakAPI() throws PolarisException {
        Configuration configuration = ConfigAPIFactory.defaultConfig();
        return CircuitBreakAPIFactory.createCircuitBreakAPIByConfig(configuration);
    }

    public static CircuitBreakAPI createCircuitBreakAPIByContext(SDKContext sdkContext) throws PolarisException {
        DefaultCircuitBreakAPI defaultCircuitBreakAPI = new DefaultCircuitBreakAPI(sdkContext);
        defaultCircuitBreakAPI.init();
        return defaultCircuitBreakAPI;
    }

    public static CircuitBreakAPI createCircuitBreakAPIByConfig(Configuration config) throws PolarisException {
        SDKContext context = SDKContext.initContextByConfig((Configuration)config);
        return CircuitBreakAPIFactory.createCircuitBreakAPIByContext(context);
    }

    public static CircuitBreakAPI createCircuitBreakAPIByAddress(String ... addresses) {
        return CircuitBreakAPIFactory.createCircuitBreakAPIByConfig(ConfigAPIFactory.createConfigurationByAddress(Arrays.asList(addresses)));
    }
}

