/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.consumer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.tencent.polaris.api.config.consumer.CircuitBreakerConfig;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.factory.config.plugin.PluginConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import com.tencent.polaris.factory.util.TimeStrJsonDeserializer;
import java.util.List;

public class CircuitBreakerConfigImpl
extends PluginConfigImpl
implements CircuitBreakerConfig {
    @JsonProperty
    private Boolean enable;
    @JsonProperty
    private List<String> chain;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long checkPeriod;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long sleepWindow;
    @JsonProperty
    private Integer requestCountAfterHalfOpen;
    @JsonProperty
    private Integer successCountAfterHalfOpen;
    @JsonProperty
    private Boolean enableRemotePull;

    @Override
    public boolean isEnable() {
        if (null == this.enable) {
            return false;
        }
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    @Override
    public List<String> getChain() {
        return this.chain;
    }

    public void setChain(List<String> chain) {
        this.chain = chain;
    }

    public void setRequestCountAfterHalfOpen(int requestCountAfterHalfOpen) {
        this.requestCountAfterHalfOpen = requestCountAfterHalfOpen;
    }

    public void setSuccessCountAfterHalfOpen(int successCountAfterHalfOpen) {
        this.successCountAfterHalfOpen = successCountAfterHalfOpen;
    }

    @Override
    public int getRequestCountAfterHalfOpen() {
        return this.requestCountAfterHalfOpen;
    }

    @Override
    public int getSuccessCountAfterHalfOpen() {
        return this.successCountAfterHalfOpen;
    }

    @Override
    public long getCheckPeriod() {
        if (null == this.checkPeriod) {
            return 0L;
        }
        return this.checkPeriod;
    }

    public void setCheckPeriod(long checkPeriod) {
        this.checkPeriod = checkPeriod;
    }

    @Override
    public long getSleepWindow() {
        if (null == this.sleepWindow) {
            return 0L;
        }
        return this.sleepWindow;
    }

    public void setSleepWindow(long sleepWindow) {
        this.sleepWindow = sleepWindow;
    }

    @Override
    public boolean isEnableRemotePull() {
        if (this.enableRemotePull == null) {
            return false;
        }
        return this.enableRemotePull;
    }

    public void setEnableRemotePull(boolean enableRemotePull) {
        this.enableRemotePull = enableRemotePull;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.enable, "circuitBreaker.enable");
        if (!this.enable.booleanValue()) {
            return;
        }
        if (CollectionUtils.isEmpty(this.chain)) {
            throw new IllegalArgumentException("circuitBreaker.chain cannot be empty");
        }
        ConfigUtils.validateInterval(this.checkPeriod, "circuitBreaker.checkPeriod");
        ConfigUtils.validateInterval(this.sleepWindow, "circuitBreaker.sleepWindow");
        ConfigUtils.validatePositive(this.requestCountAfterHalfOpen, "circuitBreaker.requestCountAfterHalfOpen");
        ConfigUtils.validatePositive(this.successCountAfterHalfOpen, "circuitBreaker.successCountAfterHalfOpen");
        ConfigUtils.validateNull(this.enableRemotePull, "circuitBreaker.enableRemotePull");
        this.verifyPluginConfig();
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            CircuitBreakerConfig circuitBreakerConfig = (CircuitBreakerConfig)defaultObject;
            if (null == this.enable) {
                this.setEnable(circuitBreakerConfig.isEnable());
            }
            if (CollectionUtils.isEmpty(this.chain)) {
                this.setChain(circuitBreakerConfig.getChain());
            }
            if (null == this.checkPeriod) {
                this.setCheckPeriod(circuitBreakerConfig.getCheckPeriod());
            }
            if (null == this.sleepWindow) {
                this.setSleepWindow(circuitBreakerConfig.getSleepWindow());
            }
            if (null == this.requestCountAfterHalfOpen) {
                this.setRequestCountAfterHalfOpen(circuitBreakerConfig.getRequestCountAfterHalfOpen());
            }
            if (null == this.successCountAfterHalfOpen) {
                this.setSuccessCountAfterHalfOpen(circuitBreakerConfig.getSuccessCountAfterHalfOpen());
            }
            if (null == this.enableRemotePull) {
                this.setEnableRemotePull(circuitBreakerConfig.isEnableRemotePull());
            }
            if (this.enable.booleanValue()) {
                this.setDefaultPluginConfig(circuitBreakerConfig);
            }
        }
    }

    public String toString() {
        return "CircuitBreakerConfigImpl{enable=" + this.enable + ", chain=" + this.chain + ", checkPeriod=" + this.checkPeriod + ", sleepWindow=" + this.sleepWindow + ", requestCountAfterHalfOpen=" + this.requestCountAfterHalfOpen + ", successCountAfterHalfOpen=" + this.successCountAfterHalfOpen + ", enableRemotePull=" + this.enableRemotePull + "} " + super.toString();
    }
}

