/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.global;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.tencent.polaris.api.config.global.ClusterConfig;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.factory.util.ConfigUtils;
import com.tencent.polaris.factory.util.TimeStrJsonDeserializer;
import java.util.List;

public class ClusterConfigImpl
implements ClusterConfig {
    @JsonProperty
    private String namespace;
    @JsonProperty
    private String service;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long refreshInterval;
    @JsonProperty
    private Boolean sameAsBuiltin;
    @JsonProperty
    private List<String> routers;
    @JsonProperty
    private String lbPolicy;

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getService() {
        return this.service;
    }

    @Override
    public long getRefreshInterval() {
        if (null == this.refreshInterval) {
            return 0L;
        }
        return this.refreshInterval;
    }

    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    @Override
    public List<String> getRouters() {
        return this.routers;
    }

    public void setRouters(List<String> routers) {
        this.routers = routers;
    }

    @Override
    public String getLbPolicy() {
        return this.lbPolicy;
    }

    public void setLbPolicy(String lbPolicy) {
        this.lbPolicy = lbPolicy;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setService(String service) {
        this.service = service;
    }

    @Override
    public boolean isSameAsBuiltin() {
        if (null == this.sameAsBuiltin) {
            return false;
        }
        return this.sameAsBuiltin;
    }

    public void setSameAsBuiltin(boolean sameAsBuiltin) {
        this.sameAsBuiltin = sameAsBuiltin;
    }

    @Override
    public void verify() {
        ConfigUtils.validateString(this.lbPolicy, "lbPolicy");
        if (!this.sameAsBuiltin.booleanValue() && CollectionUtils.isEmpty(this.routers)) {
            throw new IllegalArgumentException("routers should be not empty");
        }
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            ClusterConfig clusterConfig = (ClusterConfig)defaultObject;
            if (null == this.refreshInterval) {
                this.setRefreshInterval(clusterConfig.getRefreshInterval());
            }
            if (null == this.sameAsBuiltin) {
                this.setSameAsBuiltin(clusterConfig.isSameAsBuiltin());
            }
            if (CollectionUtils.isEmpty(this.routers)) {
                this.setRouters(clusterConfig.getRouters());
            }
            if (null == this.lbPolicy) {
                this.setLbPolicy(clusterConfig.getLbPolicy());
            }
        }
    }

    public String toString() {
        return "ClusterConfigImpl{namespace='" + this.namespace + '\'' + ", service='" + this.service + '\'' + ", refreshInterval=" + this.refreshInterval + ", sameAsBuiltin=" + this.sameAsBuiltin + ", routers=" + this.routers + ", lbPolicy='" + this.lbPolicy + '\'' + '}';
    }
}

