/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.tencent.polaris.factory.util.DurationUtils;
import java.io.IOException;

public class TimeStrJsonDeserializer
extends StdDeserializer<Long> {
    public TimeStrJsonDeserializer() {
        super(Long.class);
    }

    public Long deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String currentName = jsonParser.getCurrentName();
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return Long.parseLong(jsonParser.getText());
        }
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            String text = jsonParser.getText();
            return DurationUtils.parseConfigDurationStr(text, currentName, 0L, 0L);
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            double value = Double.parseDouble(jsonParser.getText());
            return (long)value;
        }
        return null;
    }
}

