/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.factory;

import com.google.common.collect.Maps;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.JustForTest;
import com.tencent.polaris.configuration.client.factory.ConfigFileFactory;
import com.tencent.polaris.configuration.client.factory.ConfigFileFactoryManager;
import com.tencent.polaris.configuration.client.factory.ConfigFilePublishFactory;
import com.tencent.polaris.configuration.client.factory.DefaultConfigFileFactory;
import com.tencent.polaris.configuration.client.factory.DefaultConfigFilePublishFactory;
import java.util.Map;

public class DefaultConfigFileFactoryManager
implements ConfigFileFactoryManager {
    private final SDKContext sdkContext;
    private ConfigFileFactory defaultConfigFileFactory;
    private ConfigFilePublishFactory defaultConfigFilePublishFactory;
    private final Map<ConfigFileMetadata, ConfigFileFactory> configFileFactories = Maps.newConcurrentMap();
    private final Map<ConfigFileMetadata, ConfigFilePublishFactory> configFilePublishFactories = Maps.newConcurrentMap();
    private static DefaultConfigFileFactoryManager instance;

    private DefaultConfigFileFactoryManager(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultConfigFileFactoryManager getInstance(SDKContext sdkContext) {
        if (instance != null) return instance;
        Class<DefaultConfigFileFactoryManager> clazz = DefaultConfigFileFactoryManager.class;
        synchronized (DefaultConfigFileFactoryManager.class) {
            if (instance != null) return instance;
            instance = new DefaultConfigFileFactoryManager(sdkContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public ConfigFileFactory getConfigFileFactory(ConfigFileMetadata configFileMetadata) {
        ConfigFileFactory factory = this.configFileFactories.get(configFileMetadata);
        if (factory != null) {
            return factory;
        }
        if (this.defaultConfigFileFactory == null) {
            this.defaultConfigFileFactory = DefaultConfigFileFactory.getInstance(this.sdkContext);
        }
        this.configFileFactories.put(configFileMetadata, this.defaultConfigFileFactory);
        return this.defaultConfigFileFactory;
    }

    @Override
    public ConfigFilePublishFactory getConfigFilePublishFactory(ConfigFileMetadata configFileMetadata) {
        ConfigFilePublishFactory factory = this.configFilePublishFactories.get(configFileMetadata);
        if (factory != null) {
            return factory;
        }
        if (this.defaultConfigFilePublishFactory == null) {
            this.defaultConfigFilePublishFactory = DefaultConfigFilePublishFactory.getInstance(this.sdkContext);
        }
        this.configFilePublishFactories.put(configFileMetadata, this.defaultConfigFilePublishFactory);
        return this.defaultConfigFilePublishFactory;
    }

    @JustForTest
    void setDefaultConfigFileFactory(ConfigFileFactory factory) {
        this.defaultConfigFileFactory = factory;
    }
}

