/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.circuitbreaker.entity;

import com.tencent.polaris.api.plugin.circuitbreaker.entity.AbstractResource;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.client.util.CommonValidator;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import java.util.Map;
import java.util.Objects;

public class SubsetResource
extends AbstractResource {
    private final String subset;
    private final Map<String, ModelProto.MatchString> metadata;

    public SubsetResource(ServiceKey service, String subset, Map<String, ModelProto.MatchString> metadata) {
        this(service, subset, metadata, null);
    }

    public SubsetResource(ServiceKey service, String subset, Map<String, ModelProto.MatchString> metadata, ServiceKey callerService) {
        super(service, callerService);
        CommonValidator.validateService((ServiceKey)service);
        CommonValidator.validateNamespaceService((String)service.getNamespace(), (String)service.getService());
        CommonValidator.validateText((String)subset, (String)"subset");
        this.subset = subset;
        this.metadata = metadata;
    }

    @Override
    public CircuitBreakerProto.Level getLevel() {
        return CircuitBreakerProto.Level.GROUP;
    }

    @Override
    public ServiceKey getService() {
        return this.service;
    }

    public String getSubset() {
        return this.subset;
    }

    public Map<String, ModelProto.MatchString> getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubsetResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubsetResource that = (SubsetResource)o;
        return Objects.equals(this.subset, that.subset);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subset);
    }

    @Override
    public String toString() {
        return "SubsetResource{subset='" + this.subset + '\'' + ", metadata=" + this.metadata + "} " + super.toString();
    }
}

