/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.impl;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.IdAwarePlugin;
import com.tencent.polaris.api.plugin.Manager;
import com.tencent.polaris.api.plugin.Plugin;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class PluginManager
implements Manager {
    private final Map<PluginType, Map<String, Plugin>> typedPlugins = new HashMap<PluginType, Map<String, Plugin>>();
    private final List<PluginType> pluginTypes;

    public PluginManager(List<PluginType> pluginTypes) {
        Collections.sort(pluginTypes);
        this.pluginTypes = pluginTypes;
    }

    @Override
    public void initPlugins(InitContext context) throws PolarisException {
        Map<Object, Object> plugins;
        int baseId = 0;
        for (PluginType pluginType : this.pluginTypes) {
            plugins = new HashMap();
            this.typedPlugins.put(pluginType, plugins);
            ServiceLoader<? extends Plugin> loader = ServiceLoader.load(pluginType.getClazz());
            for (Plugin plugin : loader) {
                ++baseId;
                String name = plugin.getName();
                if (StringUtils.isBlank((String)name) || plugins.containsKey(name)) {
                    throw new PolarisException(ErrorCode.PLUGIN_ERROR, String.format("duplicated name for plugin(name=%s, type=%s)", name, pluginType));
                }
                if (plugin instanceof IdAwarePlugin) {
                    ((IdAwarePlugin)plugin).setId(baseId);
                }
                plugins.put(name, plugin);
            }
        }
        for (PluginType pluginType : this.pluginTypes) {
            plugins = this.typedPlugins.get(pluginType);
            for (Map.Entry<Object, Object> pluginEntry : plugins.entrySet()) {
                ((Plugin)pluginEntry.getValue()).init(context);
            }
        }
    }

    @Override
    public void postContextInitPlugins(Extensions extensions) throws PolarisException {
        for (PluginType pluginType : this.pluginTypes) {
            Map<String, Plugin> plugins = this.typedPlugins.get(pluginType);
            if (MapUtils.isEmpty(plugins)) continue;
            for (Map.Entry<String, Plugin> pluginEntry : plugins.entrySet()) {
                Plugin plugin = pluginEntry.getValue();
                plugin.postContextInit(extensions);
            }
        }
    }

    @Override
    public void destroyPlugins() {
        for (int i = this.pluginTypes.size() - 1; i >= 0; --i) {
            PluginType pluginType = this.pluginTypes.get(i);
            Map<String, Plugin> plugins = this.typedPlugins.get(pluginType);
            if (MapUtils.isEmpty(plugins)) continue;
            for (Map.Entry<String, Plugin> plugin : plugins.entrySet()) {
                plugin.getValue().destroy();
            }
        }
    }

    @Override
    public Plugin getPlugin(PluginType type, String name) throws PolarisException {
        if (!this.typedPlugins.containsKey(type)) {
            throw new PolarisException(ErrorCode.PLUGIN_ERROR, String.format("plugins type(type=%s) not found", type));
        }
        Map<String, Plugin> plugins = this.typedPlugins.get(type);
        if (!plugins.containsKey(name)) {
            throw new PolarisException(ErrorCode.PLUGIN_ERROR, String.format("plugin(name=%s, type=%s) not found", name, type));
        }
        return plugins.get(name);
    }

    @Override
    public Plugin getOptionalPlugin(PluginType type, String name) {
        if (!this.typedPlugins.containsKey(type)) {
            return null;
        }
        Map<String, Plugin> plugins = this.typedPlugins.get(type);
        if (!plugins.containsKey(name)) {
            return null;
        }
        return plugins.get(name);
    }

    @Override
    public Collection<Plugin> getPlugins(PluginType type) throws PolarisException {
        if (!this.typedPlugins.containsKey(type)) {
            throw new PolarisException(ErrorCode.PLUGIN_ERROR, String.format("plugins type(type=%s) not found", type));
        }
        Map<String, Plugin> plugins = this.typedPlugins.get(type);
        return plugins.values();
    }
}

