/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.common;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.IdAwarePlugin;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.utils.CollectionUtils;
import java.util.Collection;

public abstract class AbstractServiceRouter
extends Destroyable
implements ServiceRouter,
IdAwarePlugin {
    private int id;
    protected Extensions extensions;

    private void validateParams(RouteInfo routeInfo, ServiceInstances instances) throws PolarisException {
        if (instances == null || CollectionUtils.isEmpty((Collection)instances.getInstances())) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "GetFilteredInstances param invalid, empty instances");
        }
        if (routeInfo == null) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "GetFilteredInstances param invalid, routeInfo can't be nil");
        }
        if (routeInfo.getDestService() == null) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "GetFilteredInstances param invalid, destService must exist");
        }
    }

    public PluginType getType() {
        return PluginTypes.SERVICE_ROUTER.getBaseType();
    }

    public RouteResult getFilteredInstances(RouteInfo routeInfo, ServiceInstances instances) throws PolarisException {
        this.validateParams(routeInfo, instances);
        return this.router(routeInfo, instances);
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
        this.extensions = extensions;
    }

    public boolean enable(RouteInfo routeInfo, ServiceMetadata dstSvcInfo) {
        Boolean enableValue = routeInfo.routerIsEnabled(this.getName());
        return null == enableValue || enableValue != false;
    }

    public abstract RouteResult router(RouteInfo var1, ServiceInstances var2) throws PolarisException;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

