/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.handler;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.factory.util.TimeStrJsonDeserializer;
import com.tencent.polaris.logging.LoggerFactory;
import org.slf4j.Logger;

public class PrometheusHandlerConfig
implements Verifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusHandlerConfig.class);
    public static final Integer DEFAULT_MIN_PULL_PORT = 28080;
    public static final Integer DEFAULT_MAX_PULL_PORT = DEFAULT_MIN_PULL_PORT + 10;
    @JsonProperty
    private String host = "0.0.0.0";
    @JsonProperty
    private Integer port = DEFAULT_MIN_PULL_PORT;
    @JsonProperty
    private String path = "/metrics";
    @JsonProperty
    private String type;
    @JsonProperty
    private String address;
    @JsonProperty
    @JsonDeserialize(using=TimeStrJsonDeserializer.class)
    private Long pushInterval = 10000L;
    @JsonProperty
    private Boolean openGzip = false;

    public void verify() {
    }

    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            PrometheusHandlerConfig config = (PrometheusHandlerConfig)defaultObject;
            if (StringUtils.isBlank((String)this.type)) {
                this.setType(config.getType());
            }
            if (StringUtils.isBlank((String)this.host)) {
                this.setHost(config.getHost());
            }
            if (this.port == null) {
                this.setPort(config.getPort());
            }
            if (StringUtils.isBlank((String)this.path)) {
                this.setPath(config.getPath());
            }
            if (StringUtils.isBlank((String)this.address)) {
                this.setAddress(config.getAddress());
            }
            if (null == this.pushInterval) {
                if (config.getPushInterval() != null) {
                    this.setPushInterval(config.getPushInterval());
                } else {
                    this.setPushInterval(10000L);
                }
            }
            if (null == this.openGzip) {
                if (config.isOpenGzip() != null) {
                    this.setOpenGzip(config.isOpenGzip());
                } else {
                    this.setOpenGzip(false);
                }
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getPushInterval() {
        return this.pushInterval;
    }

    public void setPushInterval(Long pushInterval) {
        this.pushInterval = pushInterval;
    }

    public Boolean isOpenGzip() {
        return this.openGzip;
    }

    public void setOpenGzip(Boolean openGzip) {
        this.openGzip = openGzip;
    }
}

