/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.common.support;

import com.qq.tars.common.util.concurrent.TaskThreadFactory;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ScheduledExecutorManager
implements ScheduledExecutorService {
    private static final ScheduledExecutorManager instance = new ScheduledExecutorManager();
    private ScheduledThreadPoolExecutor taskExecutor = new ScheduledThreadPoolExecutor(4);
    private final Lock lock = new ReentrantLock();

    private ScheduledExecutorManager() {
        this.taskExecutor.setThreadFactory(new TaskThreadFactory("tars-schedule-executor-"));
    }

    public static ScheduledExecutorManager getInstance() {
        return instance;
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.taskExecutor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.taskExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.taskExecutor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.taskExecutor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.checkMaxSize();
        return this.taskExecutor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.checkMaxSize();
        return this.taskExecutor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.checkMaxSize();
        return this.taskExecutor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.taskExecutor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.taskExecutor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.taskExecutor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.taskExecutor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.checkMaxSize();
        this.taskExecutor.execute(command);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.checkMaxSize();
        return this.taskExecutor.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.checkMaxSize();
        return this.taskExecutor.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.checkMaxSize();
        return this.taskExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.checkMaxSize();
        return this.taskExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    private void checkMaxSize() throws RejectedExecutionException {
        int count = this.taskExecutor.getQueue().size();
        this.lock.lock();
        try {
            int maxQueueSize = 20000;
            if (count >= maxQueueSize) {
                throw new RejectedExecutionException("the queue is full, the max queue size is " + maxQueueSize);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

