/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.property;

import com.qq.tars.client.Communicator;
import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.net.util.Utils;
import com.qq.tars.rpc.exc.TarsException;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.support.log.LoggerFactory;
import com.qq.tars.support.property.prx.PropertyFPrx;
import com.qq.tars.support.property.prx.StatPropInfo;
import com.qq.tars.support.property.prx.StatPropMsgBody;
import com.qq.tars.support.property.prx.StatPropMsgHead;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class PropertyReportHelper {
    private static final Logger omLogger = LoggerFactory.getOmLogger();
    private static final PropertyReportHelper Instance = new PropertyReportHelper();
    private static final int MAX_REPORT_SIZE = 1400;
    private Map<String, PropertyReporter> reporters = new ConcurrentHashMap<String, PropertyReporter>();
    private Communicator communicator;
    private String moduleName;
    private volatile boolean initialized = false;

    private PropertyReportHelper() {
    }

    public static PropertyReportHelper getInstance() {
        return Instance;
    }

    public synchronized void setPropertyInfo(Communicator comm, String moduleName) {
        this.init(comm, moduleName);
    }

    public synchronized void init(Communicator comm, String moduleName) {
        if (this.initialized) {
            omLogger.warn("PropertyReporter|setPropertyInfo method should be called once at most");
            return;
        }
        this.communicator = comm;
        this.moduleName = moduleName;
        this.initialized = true;
    }

    public synchronized void createPropertyReporter(String propRptName, Policy ... policies) {
        if (policies.length == 0) {
            throw new TarsException("PropertyReporter|at least one policy instance should be given");
        }
        if (!this.reporters.containsKey(propRptName)) {
            PropertyReporter reporter = new PropertyReporter(this.moduleName, propRptName, policies);
            this.reporters.put(propRptName, reporter);
        }
    }

    public void reportPropertyValue(String propRptName, int value) {
        PropertyReporter reporter = this.reporters.get(propRptName);
        if (reporter == null) {
            return;
        }
        reporter.report(value);
    }

    public void report() {
        try {
            if (!this.initialized) {
                return;
            }
            PropertyFPrx propertyFPrx = this.communicator.stringToProxy(PropertyFPrx.class, ConfigurationManager.getInstance().getServerConfig().getCommunicatorConfig().getProperty());
            HashMap<StatPropMsgHead, StatPropMsgBody> sendData = new HashMap<StatPropMsgHead, StatPropMsgBody>();
            int sendLen = 0;
            for (PropertyReporter reporter : this.reporters.values()) {
                ReportData data = reporter.getReportData();
                if (sendLen + data.len <= 1400) {
                    sendData.put(data.head, data.body);
                    sendLen += data.len;
                    continue;
                }
                propertyFPrx.async_reportPropMsg(null, sendData);
                sendData.clear();
                sendData.put(data.head, data.body);
                sendLen = data.len;
            }
            if (sendData.size() != 0) {
                propertyFPrx.async_reportPropMsg(null, sendData);
            }
        }
        catch (Throwable t) {
            omLogger.error("PropertyReporter|ReportThread error", t);
        }
    }

    public static class PropertyReporter {
        private static final int PROPERTY_PROTOCOL_LEN = 50;
        private Collection<Policy> policies;
        private String propRptName;
        private String moduleName;
        private String ip = "";
        private String setName = "";
        private String setArea = "";
        private String setID = "";

        public PropertyReporter(String moduleName, String propRptName, Policy[] policies) {
            CommunicatorConfig config = ConfigurationManager.getInstance().getServerConfig().getCommunicatorConfig();
            String string = this.moduleName = !config.isEnableSet() ? moduleName : String.format("%s.%s%s%s", moduleName, config.getSetName(), config.getSetArea(), config.getSetID());
            if (config.isEnableSet()) {
                this.setName = config.getSetName();
                this.setArea = config.getSetArea();
                this.setID = config.getSetID();
            }
            this.propRptName = propRptName;
            if (ConfigurationManager.getInstance().getCommunicatorConfig().isEnableSet()) {
                String[] sets = ConfigurationManager.getInstance().getCommunicatorConfig().getSetDivision().split("\\.");
                this.moduleName = moduleName + "." + sets[0] + sets[1] + sets[2];
            } else {
                this.moduleName = moduleName;
            }
            this.ip = ConfigurationManager.getInstance().getServerConfig().getLocalIP();
            HashMap<String, Policy> map = new HashMap<String, Policy>();
            for (Policy policy : policies) {
                map.put(policy.desc(), policy);
            }
            this.policies = map.values();
            this.ip = Utils.getLocalIp();
        }

        public void report(int value) {
            for (Policy policy : this.policies) {
                policy.set(value);
            }
        }

        public ReportData getReportData() {
            int len = 0;
            StatPropMsgHead head = new StatPropMsgHead(this.moduleName, this.ip, this.propRptName, this.setName, this.setArea, this.setID, null, 1);
            len += this.moduleName.length() + this.propRptName.length();
            int size = this.policies.size();
            len += 50 + size;
            ArrayList<StatPropInfo> statPropInfos = new ArrayList<StatPropInfo>(this.policies.size());
            for (Policy policy : this.policies) {
                String desc = policy.desc();
                String value = policy.get();
                statPropInfos.add(new StatPropInfo(desc, value));
                len += desc.length() + value.length();
            }
            StatPropMsgBody body = new StatPropMsgBody();
            body.setVInfo(statPropInfos);
            return new ReportData(head, body, len);
        }
    }

    private static class ReportData {
        public StatPropMsgHead head;
        public StatPropMsgBody body;
        public int len;

        public ReportData(StatPropMsgHead head, StatPropMsgBody body, int len) {
            this.head = head;
            this.body = body;
            this.len = len;
        }
    }

    public static interface Policy {
        public String desc();

        public String get();

        public void set(int var1);
    }
}

