/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client;

import com.qq.tars.client.Communicator;
import com.qq.tars.client.ObjectProxy;
import com.qq.tars.client.ServantProxy;
import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.rpc.common.LoadBalance;
import com.qq.tars.rpc.common.ProtocolInvoker;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

class ServantProxyFactory {
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();
    private final Communicator communicator;

    public ServantProxyFactory(Communicator communicator) {
        this.communicator = communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Object getServantProxy(Class<T> clazz, String objName, String setDivision, ServantProxyConfig servantProxyConfig, LoadBalance loadBalance, ProtocolInvoker<T> protocolInvoker) {
        String key = setDivision != null ? clazz.getSimpleName() + objName + setDivision : clazz.getSimpleName() + objName;
        Object proxy = this.cache.get(key);
        if (proxy == null) {
            this.lock.lock();
            try {
                proxy = this.cache.get(key);
                if (proxy == null) {
                    ObjectProxy<T> objectProxy = this.communicator.getObjectProxyFactory().getObjectProxy(clazz, objName, setDivision, servantProxyConfig, loadBalance, protocolInvoker);
                    this.cache.put(key, this.createProxy(clazz, objectProxy));
                    proxy = this.cache.get(key);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return proxy;
    }

    private <T> Object createProxy(Class<T> clazz, ObjectProxy<T> objectProxy) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz, ServantProxy.class}, objectProxy);
    }

    public Iterator<Object> getProxyIterator() {
        return this.cache.values().iterator();
    }
}

