/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.om;

import com.qq.tars.common.support.ScheduledExecutorManager;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.support.node.NodeHelper;
import com.qq.tars.support.om.ServerStatHelper;
import com.qq.tars.support.property.PropertyReportHelper;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class ScheduledServiceMngr {
    private static final ScheduledServiceMngr Instance = new ScheduledServiceMngr();
    private static final int HEART_BEAT_INTERVAL = 10;
    private static final int PROPERTY_REPORT_MIN_INTERVAL = 30000;
    private static int REPORT_INTERVAL = ConfigurationManager.getInstance().getServerConfig().getCommunicatorConfig().getReportInterval();
    private final Random random = new Random(System.currentTimeMillis() / 1000L);
    private ScheduledExecutorManager taskExecutorManager = ScheduledExecutorManager.getInstance();

    private ScheduledServiceMngr() {
    }

    public static ScheduledServiceMngr getInstance() {
        return Instance;
    }

    public void start() {
        this.startHandleService();
    }

    public void shutdown() {
        this.taskExecutorManager.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.taskExecutorManager.shutdownNow();
    }

    public boolean isShutdown() {
        return this.taskExecutorManager.isShutdown();
    }

    public boolean isTerminated() {
        return this.taskExecutorManager.isTerminated();
    }

    private void startHandleService() {
        Thread nodeHandler = new Thread((Runnable)new NodeHandleThread(), "HeartBeat");
        this.taskExecutorManager.scheduleAtFixedRate(nodeHandler, 0L, 10L, TimeUnit.SECONDS);
        int initialDelay = REPORT_INTERVAL + this.random.nextInt(30) * 1000;
        Thread statHandler = new Thread((Runnable)new StatHandleThread(), "ServerStat");
        this.taskExecutorManager.scheduleAtFixedRate(statHandler, initialDelay, REPORT_INTERVAL, TimeUnit.MILLISECONDS);
        if (REPORT_INTERVAL < 30000) {
            REPORT_INTERVAL = 30000;
        }
        initialDelay = REPORT_INTERVAL + this.random.nextInt(30) * 1000;
        Thread propertyHandler = new Thread((Runnable)new PropertyHandleThread(), "PropertyReport");
        this.taskExecutorManager.scheduleAtFixedRate(propertyHandler, initialDelay, REPORT_INTERVAL, TimeUnit.MILLISECONDS);
    }

    class StatHandleThread
    implements Runnable {
        StatHandleThread() {
        }

        @Override
        public void run() {
            ServerStatHelper.getInstance().report();
        }
    }

    class PropertyHandleThread
    implements Runnable {
        PropertyHandleThread() {
        }

        @Override
        public void run() {
            PropertyReportHelper.getInstance().report();
        }
    }

    class NodeHandleThread
    implements Runnable {
        NodeHandleThread() {
        }

        @Override
        public void run() {
            NodeHelper.getInstance().keepAlive();
        }
    }
}

