/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.trace;

import brave.Tracing;
import brave.opentracing.BraveTracer;
import brave.sampler.Sampler;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.server.config.ServerConfig;
import com.qq.tars.support.trace.TraceManager;
import com.qq.tars.support.trace.exc.NotSupportedSuchSampleEncodingException;
import com.qq.tars.support.trace.exc.NotSupportedSuchSampleTypeException;
import io.opentracing.Tracer;
import java.util.HashMap;
import zipkin2.Span;
import zipkin2.codec.Encoding;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.kafka08.KafkaSender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

public class TarsTraceZipkinConfiguration {
    private ServerConfig serverConfig = ConfigurationManager.getInstance().getServerConfig();
    private volatile boolean isTrace = false;
    private Sender sender;
    private Reporter<Span> reporter;
    private static final TarsTraceZipkinConfiguration instance = new TarsTraceZipkinConfiguration();

    private TarsTraceZipkinConfiguration() {
    }

    public static TarsTraceZipkinConfiguration getInstance() {
        return instance;
    }

    public void init() {
        boolean bl = this.isTrace = this.serverConfig.getSampleRate() > 0.0f;
        if (this.isTrace) {
            try {
                this.createSender();
                this.reporter = AsyncReporter.builder((Sender)this.sender).build();
                HashMap<String, Tracer> traces = new HashMap<String, Tracer>();
                for (String servant : this.serverConfig.getServantAdapterConfMap().keySet()) {
                    if (servant.equals("AdminObj")) continue;
                    Tracing tracing = Tracing.newBuilder().localServiceName(servant).spanReporter(this.reporter).sampler(Sampler.create((float)this.serverConfig.getSampleRate())).build();
                    BraveTracer tracer = BraveTracer.create((Tracing)tracing);
                    traces.put(servant, (Tracer)tracer);
                }
                TraceManager.getInstance().putTracers(traces);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createSender() throws NotSupportedSuchSampleTypeException, NotSupportedSuchSampleEncodingException {
        if ("http".equals(this.serverConfig.getSampleType())) {
            String baseurl = this.serverConfig.getSampleAddress();
            String url = baseurl + (baseurl.endsWith("/") ? "" : "/") + "api/v2/spans";
            Encoding codec = this.createCodec();
            this.sender = URLConnectionSender.newBuilder().encoding(codec).endpoint(url).build();
        } else if ("kafka08".equals(this.serverConfig.getSampleType())) {
            Encoding codec = this.createCodec();
            this.sender = KafkaSender.newBuilder().encoding(codec).bootstrapServers(this.serverConfig.getSampleAddress()).build();
        } else if ("kafka".equals(this.serverConfig.getSampleType())) {
            Encoding codec = this.createCodec();
            this.sender = zipkin2.reporter.kafka11.KafkaSender.newBuilder().encoding(codec).bootstrapServers(this.serverConfig.getSampleAddress()).build();
        } else {
            throw new NotSupportedSuchSampleTypeException("unsupported sample type");
        }
    }

    private Encoding createCodec() throws NotSupportedSuchSampleEncodingException {
        if ("json".endsWith(this.serverConfig.getSampleEncoding())) {
            return Encoding.JSON;
        }
        if ("proto".endsWith(this.serverConfig.getSampleEncoding())) {
            return Encoding.PROTO3;
        }
        throw new NotSupportedSuchSampleEncodingException("unsupported sample encoding");
    }
}

