/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.spring.bean;

import com.qq.tars.rpc.exc.TarsException;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.server.config.ServantAdapterConfig;
import com.qq.tars.server.config.ServerConfig;
import com.qq.tars.spring.annotation.TarsHttpService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;

public class ServletContainerCustomizer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory>,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ServletContainerCustomizer.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        Map beans = this.applicationContext.getBeansWithAnnotation(TarsHttpService.class);
        int port = 8080;
        String host = null;
        ServerConfig serverCfg = ConfigurationManager.getInstance().getServerConfig();
        try {
            for (Object bean : beans.values()) {
                String objName = ((TarsHttpService)AnnotationUtils.getAnnotation(bean.getClass(), TarsHttpService.class)).value();
                String homeName = String.format("%s.%s.%s", serverCfg.getApplication(), serverCfg.getServerName(), objName);
                ServantAdapterConfig adapterConfig = (ServantAdapterConfig)ConfigurationManager.getInstance().getServerConfig().getServantAdapterConfMap().get(homeName);
                if (adapterConfig.getProtocol().equals("tars")) {
                    throw new TarsException("[TARS] http servant can not use tars protocol");
                }
                port = adapterConfig.getEndpoint().port();
                host = adapterConfig.getEndpoint().host();
            }
        }
        catch (Exception e) {
            System.err.println("[TARS] load http servant failed");
            e.printStackTrace();
        }
        if (host != null) {
            try {
                factory.setAddress(InetAddress.getByName(host));
                factory.setPort(port);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        System.out.println("[TARS] http server start at " + port);
    }
}

