/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.producer;

import com.google.common.util.concurrent.ListenableFuture;
import com.tencentcloudapi.cls.producer.AsyncProducerConfig;
import com.tencentcloudapi.cls.producer.Callback;
import com.tencentcloudapi.cls.producer.Result;
import com.tencentcloudapi.cls.producer.common.BatchHandler;
import com.tencentcloudapi.cls.producer.common.LogAccumulator;
import com.tencentcloudapi.cls.producer.common.LogItem;
import com.tencentcloudapi.cls.producer.common.ProducerBatch;
import com.tencentcloudapi.cls.producer.common.RetryQueue;
import com.tencentcloudapi.cls.producer.common.SendThreadPool;
import com.tencentcloudapi.cls.producer.common.TimerSendBatchTask;
import com.tencentcloudapi.cls.producer.errors.MaxBatchCountExceedException;
import com.tencentcloudapi.cls.producer.errors.ProducerException;
import com.tencentcloudapi.cls.producer.util.Utils;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncProducerClient {
    private static final AtomicInteger INSTANCE_ID_GENERATOR = new AtomicInteger(0);
    private final AsyncProducerConfig producerConfig;
    private final Semaphore memoryController;
    private final RetryQueue retryQueue;
    private final SendThreadPool sendThreadPool;
    private final LogAccumulator accumulator;
    private final TimerSendBatchTask timerSendBatchTask;
    private final BatchHandler successBatchHandler;
    private final BatchHandler failureBatchHandler;
    private final AtomicInteger batchCount = new AtomicInteger(0);

    public AsyncProducerConfig getProducerConfig() {
        return this.producerConfig;
    }

    public int getBatchCount() {
        return this.batchCount.get();
    }

    public int availableMemoryInBytes() {
        return this.memoryController.availablePermits();
    }

    public AsyncProducerClient(AsyncProducerConfig producerConfig) {
        int instanceId = INSTANCE_ID_GENERATOR.getAndIncrement();
        String name = "tencent-cloud-cls-log-producer-" + instanceId;
        String producerHash = Utils.generateProducerHash(instanceId);
        this.producerConfig = producerConfig;
        this.memoryController = new Semaphore(producerConfig.getTotalSizeInBytes());
        this.retryQueue = new RetryQueue();
        LinkedBlockingQueue<ProducerBatch> successQueue = new LinkedBlockingQueue<ProducerBatch>();
        LinkedBlockingQueue<ProducerBatch> failureQueue = new LinkedBlockingQueue<ProducerBatch>();
        this.sendThreadPool = new SendThreadPool(producerConfig.getSendThreadCount(), name);
        this.accumulator = new LogAccumulator(producerHash, producerConfig, this.memoryController, this.retryQueue, successQueue, failureQueue, this.batchCount, this.sendThreadPool);
        this.timerSendBatchTask = new TimerSendBatchTask(name + "-timer-send-batch", true, producerConfig, this.accumulator, this.retryQueue, successQueue, failureQueue, this.sendThreadPool, this.batchCount);
        this.successBatchHandler = new BatchHandler(name + "-success-batch-handler", true, successQueue, this.batchCount, this.memoryController);
        this.failureBatchHandler = new BatchHandler(name + "-failure-batch-handler", true, failureQueue, this.batchCount, this.memoryController);
        this.timerSendBatchTask.start();
        this.successBatchHandler.start();
        this.failureBatchHandler.start();
    }

    public ListenableFuture<Result> putLogs(String topicId, List<LogItem> logItems, Callback callback) throws InterruptedException, ProducerException {
        if (topicId == null || topicId.isEmpty()) {
            throw new IllegalArgumentException("topicIDInvalid", new Exception("topic id cannot be empty"));
        }
        if (logItems.isEmpty()) {
            throw new IllegalArgumentException("logItems cannot be empty");
        }
        int count = logItems.size();
        if (count > 10000) {
            throw new MaxBatchCountExceedException("the log list size is " + count + " which exceeds the MAX_BATCH_COUNT " + 10000);
        }
        return this.accumulator.append(topicId, logItems, callback);
    }

    public void close() throws InterruptedException, ProducerException {
        this.close(Long.MAX_VALUE);
    }

    public void close(long timeoutMs) throws InterruptedException, ProducerException {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException("timeoutMs must be greater than or equal to 0, got " + timeoutMs);
        }
        ProducerException firstException = null;
        try {
            timeoutMs = this.closeTimerSendBatchTask(timeoutMs);
            timeoutMs = this.closeSendThreadPool(timeoutMs);
            timeoutMs = this.closeSuccessBatchHandler(timeoutMs);
            this.closeFailureBatchHandler(timeoutMs);
        }
        catch (ProducerException e) {
            firstException = e;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    private long closeTimerSendBatchTask(long timeoutMs) throws InterruptedException, ProducerException {
        long startMs = System.currentTimeMillis();
        this.accumulator.close();
        this.retryQueue.close();
        this.timerSendBatchTask.close();
        this.timerSendBatchTask.join(timeoutMs);
        if (this.timerSendBatchTask.isAlive()) {
            throw new ProducerException("the mover thread is still alive");
        }
        long nowMs = System.currentTimeMillis();
        return Math.max(0L, timeoutMs - nowMs + startMs);
    }

    private long closeSendThreadPool(long timeoutMs) throws InterruptedException, ProducerException {
        long startMs = System.currentTimeMillis();
        this.sendThreadPool.shutdown();
        if (!this.sendThreadPool.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
            throw new ProducerException("the ioThreadPool is not fully terminated");
        }
        long nowMs = System.currentTimeMillis();
        return Math.max(0L, timeoutMs - nowMs + startMs);
    }

    private long closeSuccessBatchHandler(long timeoutMs) throws InterruptedException, ProducerException {
        boolean invokedFromCallback;
        long startMs = System.currentTimeMillis();
        this.successBatchHandler.close();
        boolean bl = invokedFromCallback = Thread.currentThread() == this.successBatchHandler;
        if (invokedFromCallback) {
            return timeoutMs;
        }
        this.successBatchHandler.join(timeoutMs);
        if (this.successBatchHandler.isAlive()) {
            throw new ProducerException("the success batch handler thread is still alive");
        }
        long nowMs = System.currentTimeMillis();
        return Math.max(0L, timeoutMs - nowMs + startMs);
    }

    private long closeFailureBatchHandler(long timeoutMs) throws InterruptedException, ProducerException {
        boolean invokedFromCallback;
        long startMs = System.currentTimeMillis();
        this.failureBatchHandler.close();
        boolean bl = invokedFromCallback = Thread.currentThread() == this.successBatchHandler || Thread.currentThread() == this.failureBatchHandler;
        if (invokedFromCallback) {
            return timeoutMs;
        }
        this.failureBatchHandler.join(timeoutMs);
        if (this.failureBatchHandler.isAlive()) {
            throw new ProducerException("the failure batch handler thread is still alive");
        }
        long nowMs = System.currentTimeMillis();
        return Math.max(0L, timeoutMs - nowMs + startMs);
    }
}

