/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.producer.common;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.tencentcloudapi.cls.producer.Callback;
import com.tencentcloudapi.cls.producer.Result;
import com.tencentcloudapi.cls.producer.common.Attempt;
import com.tencentcloudapi.cls.producer.common.LogItem;
import com.tencentcloudapi.cls.producer.errors.ResultFailedException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerBatch
implements Delayed {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerBatch.class);
    private long nextRetryMs;
    private final String packageId;
    private final String topicId;
    private final int batchSizeThresholdInBytes;
    private final int batchCountThreshold;
    private final long createdMs;
    private int curBatchSizeInBytes;
    private int curBatchCount;
    private int attemptCount;
    private final List<LogItem> logItems = new ArrayList<LogItem>();
    private final List<Thunk> thunks = new ArrayList<Thunk>();
    private final EvictingQueue<Attempt> reservedAttempts;

    public long getNextRetryMs() {
        return this.nextRetryMs;
    }

    public void setNextRetryMs(long nextRetryMs) {
        this.nextRetryMs = nextRetryMs;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public List<LogItem> getLogItems() {
        return this.logItems;
    }

    public int getCurBatchSizeInBytes() {
        return this.curBatchSizeInBytes;
    }

    public int getRetries() {
        return Math.max(0, this.attemptCount - 1);
    }

    public ProducerBatch(String topicId, String packageId, int batchSizeThresholdInBytes, int batchCountThreshold, int maxReservedAttempts, long nowMs) {
        this.topicId = topicId;
        this.packageId = packageId;
        this.createdMs = nowMs;
        this.batchSizeThresholdInBytes = batchSizeThresholdInBytes;
        this.batchCountThreshold = batchCountThreshold;
        this.curBatchCount = 0;
        this.curBatchSizeInBytes = 0;
        this.attemptCount = 0;
        this.reservedAttempts = EvictingQueue.create(maxReservedAttempts);
    }

    public ListenableFuture<Result> tryAppend(LogItem item, int sizeInBytes, Callback callback) {
        if (this.hasRoomFor(sizeInBytes, 1)) {
            return null;
        }
        SettableFuture<Result> future = SettableFuture.create();
        this.logItems.add(item);
        this.thunks.add(new Thunk(callback, future));
        ++this.curBatchCount;
        this.curBatchSizeInBytes += sizeInBytes;
        return future;
    }

    public ListenableFuture<Result> tryAppend(List<LogItem> items, int sizeInBytes, Callback callback) {
        if (this.hasRoomFor(sizeInBytes, items.size())) {
            return null;
        }
        SettableFuture<Result> future = SettableFuture.create();
        this.logItems.addAll(items);
        this.thunks.add(new Thunk(callback, future));
        this.curBatchCount += items.size();
        this.curBatchSizeInBytes += sizeInBytes;
        return future;
    }

    public boolean isMeetSendCondition() {
        return this.curBatchSizeInBytes >= this.batchSizeThresholdInBytes || this.curBatchCount >= this.batchCountThreshold;
    }

    private boolean hasRoomFor(int sizeInBytes, int count) {
        return this.curBatchSizeInBytes + sizeInBytes > 0x500000 || this.curBatchCount + count > 10000;
    }

    private long createdTimeMs(long nowMs) {
        return Math.max(0L, nowMs - this.createdMs);
    }

    public long remainingMs(long nowMs, long lingerMs) {
        return lingerMs - this.createdTimeMs(nowMs);
    }

    public void appendAttempt(Attempt attempt) {
        this.reservedAttempts.add(attempt);
        ++this.attemptCount;
    }

    public void fireCallbacksAndSetFutures() {
        ArrayList<Attempt> attempts = new ArrayList<Attempt>(this.reservedAttempts);
        Attempt attempt = Iterables.getLast(attempts);
        Result result = new Result(attempt.isSuccess(), attempts, this.attemptCount);
        this.fireCallbacks(result);
        this.setFutures(result);
    }

    private void fireCallbacks(Result result) {
        for (Thunk thunk : this.thunks) {
            try {
                if (thunk.callback == null) continue;
                thunk.callback.onCompletion(result);
            }
            catch (Exception e) {
                LOGGER.error("Failed to execute user-provided callback, topic_id={}, e=", (Object)this.topicId, (Object)e);
            }
        }
    }

    private void setFutures(Result result) {
        for (Thunk thunk : this.thunks) {
            try {
                if (result.isSuccessful()) {
                    thunk.future.set(result);
                    continue;
                }
                thunk.future.setException(new ResultFailedException(result));
            }
            catch (Exception e) {
                LOGGER.error("Failed to set future, topic_id={}, e=", (Object)this.topicId, (Object)e);
            }
        }
    }

    @Override
    public long getDelay(@Nonnull TimeUnit unit) {
        return unit.convert(this.nextRetryMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(@Nonnull Delayed o) {
        return (int)(this.nextRetryMs - ((ProducerBatch)o).getNextRetryMs());
    }

    private static final class Thunk {
        final Callback callback;
        final SettableFuture<Result> future;

        Thunk(Callback callback, SettableFuture<Result> future) {
            this.callback = callback;
            this.future = future;
        }
    }
}

