/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.node.TextNode;
import com.theokanning.openai.DeleteResult;
import com.theokanning.openai.ListSearchParameters;
import com.theokanning.openai.OpenAiError;
import com.theokanning.openai.OpenAiHttpException;
import com.theokanning.openai.OpenAiResponse;
import com.theokanning.openai.assistants.Assistant;
import com.theokanning.openai.assistants.AssistantFile;
import com.theokanning.openai.assistants.AssistantFileRequest;
import com.theokanning.openai.assistants.AssistantRequest;
import com.theokanning.openai.assistants.ModifyAssistantRequest;
import com.theokanning.openai.audio.CreateSpeechRequest;
import com.theokanning.openai.audio.CreateTranscriptionRequest;
import com.theokanning.openai.audio.CreateTranslationRequest;
import com.theokanning.openai.audio.TranscriptionResult;
import com.theokanning.openai.audio.TranslationResult;
import com.theokanning.openai.billing.BillingUsage;
import com.theokanning.openai.billing.Subscription;
import com.theokanning.openai.client.OpenAiApi;
import com.theokanning.openai.completion.CompletionChunk;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionChunk;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.completion.chat.ChatFunction;
import com.theokanning.openai.completion.chat.ChatFunctionCall;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import com.theokanning.openai.edit.EditRequest;
import com.theokanning.openai.edit.EditResult;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.file.File;
import com.theokanning.openai.fine_tuning.FineTuningEvent;
import com.theokanning.openai.fine_tuning.FineTuningJob;
import com.theokanning.openai.fine_tuning.FineTuningJobRequest;
import com.theokanning.openai.finetune.FineTuneEvent;
import com.theokanning.openai.finetune.FineTuneRequest;
import com.theokanning.openai.finetune.FineTuneResult;
import com.theokanning.openai.image.CreateImageEditRequest;
import com.theokanning.openai.image.CreateImageRequest;
import com.theokanning.openai.image.CreateImageVariationRequest;
import com.theokanning.openai.image.ImageResult;
import com.theokanning.openai.messages.Message;
import com.theokanning.openai.messages.MessageFile;
import com.theokanning.openai.messages.MessageRequest;
import com.theokanning.openai.messages.ModifyMessageRequest;
import com.theokanning.openai.model.Model;
import com.theokanning.openai.moderation.ModerationRequest;
import com.theokanning.openai.moderation.ModerationResult;
import com.theokanning.openai.runs.Run;
import com.theokanning.openai.runs.RunCreateRequest;
import com.theokanning.openai.service.AuthenticationInterceptor;
import com.theokanning.openai.service.ChatCompletionRequestMixIn;
import com.theokanning.openai.service.ChatFunctionCallMixIn;
import com.theokanning.openai.service.ChatFunctionMixIn;
import com.theokanning.openai.service.ChatMessageAccumulator;
import com.theokanning.openai.service.ResponseBodyCallback;
import com.theokanning.openai.service.SSE;
import com.theokanning.openai.threads.Thread;
import com.theokanning.openai.threads.ThreadRequest;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Single;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAiService {
    private static final String BASE_URL = "https://api.openai.com/";
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
    private static final ObjectMapper mapper = OpenAiService.defaultObjectMapper();
    private final OpenAiApi api;
    private final ExecutorService executorService;

    public OpenAiService(String token) {
        this(token, DEFAULT_TIMEOUT);
    }

    public OpenAiService(String token, Duration timeout) {
        ObjectMapper mapper = OpenAiService.defaultObjectMapper();
        OkHttpClient client = OpenAiService.defaultClient(token, timeout);
        Retrofit retrofit = OpenAiService.defaultRetrofit(client, mapper);
        this.api = (OpenAiApi)retrofit.create(OpenAiApi.class);
        this.executorService = client.dispatcher().executorService();
    }

    public OpenAiService(OpenAiApi api) {
        this.api = api;
        this.executorService = null;
    }

    public OpenAiService(OpenAiApi api, ExecutorService executorService) {
        this.api = api;
        this.executorService = executorService;
    }

    public List<Model> listModels() {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listModels())).data;
    }

    public Model getModel(String modelId) {
        return (Model)OpenAiService.execute(this.api.getModel(modelId));
    }

    public CompletionResult createCompletion(CompletionRequest request) {
        return (CompletionResult)OpenAiService.execute(this.api.createCompletion(request));
    }

    public Flowable<CompletionChunk> streamCompletion(CompletionRequest request) {
        request.setStream(Boolean.valueOf(true));
        return OpenAiService.stream((Call<ResponseBody>)this.api.createCompletionStream(request), CompletionChunk.class);
    }

    public ChatCompletionResult createChatCompletion(ChatCompletionRequest request) {
        return (ChatCompletionResult)OpenAiService.execute(this.api.createChatCompletion(request));
    }

    public Flowable<ChatCompletionChunk> streamChatCompletion(ChatCompletionRequest request) {
        request.setStream(Boolean.valueOf(true));
        return OpenAiService.stream((Call<ResponseBody>)this.api.createChatCompletionStream(request), ChatCompletionChunk.class);
    }

    public EditResult createEdit(EditRequest request) {
        return (EditResult)OpenAiService.execute(this.api.createEdit(request));
    }

    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        return (EmbeddingResult)OpenAiService.execute(this.api.createEmbeddings(request));
    }

    public List<File> listFiles() {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listFiles())).data;
    }

    public File uploadFile(String purpose, String filepath) {
        java.io.File file = new java.io.File(filepath);
        RequestBody purposeBody = RequestBody.create((MediaType)MultipartBody.FORM, (String)purpose);
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"text"), (java.io.File)file);
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)filepath, (RequestBody)fileBody);
        return (File)OpenAiService.execute(this.api.uploadFile(purposeBody, body));
    }

    public DeleteResult deleteFile(String fileId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteFile(fileId));
    }

    public File retrieveFile(String fileId) {
        return (File)OpenAiService.execute(this.api.retrieveFile(fileId));
    }

    public ResponseBody retrieveFileContent(String fileId) {
        return (ResponseBody)OpenAiService.execute(this.api.retrieveFileContent(fileId));
    }

    public FineTuningJob createFineTuningJob(FineTuningJobRequest request) {
        return (FineTuningJob)OpenAiService.execute(this.api.createFineTuningJob(request));
    }

    public List<FineTuningJob> listFineTuningJobs() {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listFineTuningJobs())).data;
    }

    public FineTuningJob retrieveFineTuningJob(String fineTuningJobId) {
        return (FineTuningJob)OpenAiService.execute(this.api.retrieveFineTuningJob(fineTuningJobId));
    }

    public FineTuningJob cancelFineTuningJob(String fineTuningJobId) {
        return (FineTuningJob)OpenAiService.execute(this.api.cancelFineTuningJob(fineTuningJobId));
    }

    public List<FineTuningEvent> listFineTuningJobEvents(String fineTuningJobId) {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listFineTuningJobEvents((String)fineTuningJobId))).data;
    }

    @Deprecated
    public FineTuneResult createFineTune(FineTuneRequest request) {
        return (FineTuneResult)OpenAiService.execute(this.api.createFineTune(request));
    }

    public CompletionResult createFineTuneCompletion(CompletionRequest request) {
        return (CompletionResult)OpenAiService.execute(this.api.createFineTuneCompletion(request));
    }

    @Deprecated
    public List<FineTuneResult> listFineTunes() {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listFineTunes())).data;
    }

    @Deprecated
    public FineTuneResult retrieveFineTune(String fineTuneId) {
        return (FineTuneResult)OpenAiService.execute(this.api.retrieveFineTune(fineTuneId));
    }

    @Deprecated
    public FineTuneResult cancelFineTune(String fineTuneId) {
        return (FineTuneResult)OpenAiService.execute(this.api.cancelFineTune(fineTuneId));
    }

    @Deprecated
    public List<FineTuneEvent> listFineTuneEvents(String fineTuneId) {
        return ((OpenAiResponse)OpenAiService.execute(this.api.listFineTuneEvents((String)fineTuneId))).data;
    }

    public DeleteResult deleteFineTune(String fineTuneId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteFineTune(fineTuneId));
    }

    public ImageResult createImage(CreateImageRequest request) {
        return (ImageResult)OpenAiService.execute(this.api.createImage(request));
    }

    public ImageResult createImageEdit(CreateImageEditRequest request, String imagePath, String maskPath) {
        java.io.File image = new java.io.File(imagePath);
        java.io.File mask = null;
        if (maskPath != null) {
            mask = new java.io.File(maskPath);
        }
        return this.createImageEdit(request, image, mask);
    }

    public ImageResult createImageEdit(CreateImageEditRequest request, java.io.File image, java.io.File mask) {
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"image"), (java.io.File)image);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart("prompt", request.getPrompt()).addFormDataPart("size", request.getSize()).addFormDataPart("response_format", request.getResponseFormat()).addFormDataPart("image", "image", imageBody);
        if (request.getN() != null) {
            builder.addFormDataPart("n", request.getN().toString());
        }
        if (mask != null) {
            RequestBody maskBody = RequestBody.create((MediaType)MediaType.parse((String)"image"), (java.io.File)mask);
            builder.addFormDataPart("mask", "mask", maskBody);
        }
        if (request.getModel() != null) {
            builder.addFormDataPart("model", request.getModel());
        }
        return (ImageResult)OpenAiService.execute(this.api.createImageEdit((RequestBody)builder.build()));
    }

    public ImageResult createImageVariation(CreateImageVariationRequest request, String imagePath) {
        java.io.File image = new java.io.File(imagePath);
        return this.createImageVariation(request, image);
    }

    public ImageResult createImageVariation(CreateImageVariationRequest request, java.io.File image) {
        RequestBody imageBody = RequestBody.create((MediaType)MediaType.parse((String)"image"), (java.io.File)image);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart("size", request.getSize()).addFormDataPart("response_format", request.getResponseFormat()).addFormDataPart("image", "image", imageBody);
        if (request.getN() != null) {
            builder.addFormDataPart("n", request.getN().toString());
        }
        if (request.getModel() != null) {
            builder.addFormDataPart("model", request.getModel());
        }
        return (ImageResult)OpenAiService.execute(this.api.createImageVariation((RequestBody)builder.build()));
    }

    public TranscriptionResult createTranscription(CreateTranscriptionRequest request, String audioPath) {
        java.io.File audio = new java.io.File(audioPath);
        return this.createTranscription(request, audio);
    }

    public TranscriptionResult createTranscription(CreateTranscriptionRequest request, java.io.File audio) {
        RequestBody audioBody = RequestBody.create((MediaType)MediaType.parse((String)"audio"), (java.io.File)audio);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart("model", request.getModel()).addFormDataPart("file", audio.getName(), audioBody);
        if (request.getPrompt() != null) {
            builder.addFormDataPart("prompt", request.getPrompt());
        }
        if (request.getResponseFormat() != null) {
            builder.addFormDataPart("response_format", request.getResponseFormat());
        }
        if (request.getTemperature() != null) {
            builder.addFormDataPart("temperature", request.getTemperature().toString());
        }
        if (request.getLanguage() != null) {
            builder.addFormDataPart("language", request.getLanguage());
        }
        return (TranscriptionResult)OpenAiService.execute(this.api.createTranscription((RequestBody)builder.build()));
    }

    public TranslationResult createTranslation(CreateTranslationRequest request, String audioPath) {
        java.io.File audio = new java.io.File(audioPath);
        return this.createTranslation(request, audio);
    }

    public TranslationResult createTranslation(CreateTranslationRequest request, java.io.File audio) {
        RequestBody audioBody = RequestBody.create((MediaType)MediaType.parse((String)"audio"), (java.io.File)audio);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.get((String)"multipart/form-data")).addFormDataPart("model", request.getModel()).addFormDataPart("file", audio.getName(), audioBody);
        if (request.getPrompt() != null) {
            builder.addFormDataPart("prompt", request.getPrompt());
        }
        if (request.getResponseFormat() != null) {
            builder.addFormDataPart("response_format", request.getResponseFormat());
        }
        if (request.getTemperature() != null) {
            builder.addFormDataPart("temperature", request.getTemperature().toString());
        }
        return (TranslationResult)OpenAiService.execute(this.api.createTranslation((RequestBody)builder.build()));
    }

    public ModerationResult createModeration(ModerationRequest request) {
        return (ModerationResult)OpenAiService.execute(this.api.createModeration(request));
    }

    public ResponseBody createSpeech(CreateSpeechRequest request) {
        return (ResponseBody)OpenAiService.execute(this.api.createSpeech(request));
    }

    public Assistant createAssistant(AssistantRequest request) {
        return (Assistant)OpenAiService.execute(this.api.createAssistant(request));
    }

    public Assistant retrieveAssistant(String assistantId) {
        return (Assistant)OpenAiService.execute(this.api.retrieveAssistant(assistantId));
    }

    public Assistant modifyAssistant(String assistantId, ModifyAssistantRequest request) {
        return (Assistant)OpenAiService.execute(this.api.modifyAssistant(assistantId, request));
    }

    public DeleteResult deleteAssistant(String assistantId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteAssistant(assistantId));
    }

    public OpenAiResponse<Assistant> listAssistants(ListSearchParameters params) {
        Map queryParameters = (Map)mapper.convertValue((Object)params, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return (OpenAiResponse)OpenAiService.execute(this.api.listAssistants(queryParameters));
    }

    public AssistantFile createAssistantFile(String assistantId, AssistantFileRequest fileRequest) {
        return (AssistantFile)OpenAiService.execute(this.api.createAssistantFile(assistantId, fileRequest));
    }

    public AssistantFile retrieveAssistantFile(String assistantId, String fileId) {
        return (AssistantFile)OpenAiService.execute(this.api.retrieveAssistantFile(assistantId, fileId));
    }

    public DeleteResult deleteAssistantFile(String assistantId, String fileId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteAssistantFile(assistantId, fileId));
    }

    public OpenAiResponse<Assistant> listAssistantFiles(String assistantId, ListSearchParameters params) {
        Map queryParameters = (Map)mapper.convertValue((Object)params, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return (OpenAiResponse)OpenAiService.execute(this.api.listAssistantFiles(assistantId, queryParameters));
    }

    public Thread createThread(ThreadRequest request) {
        return (Thread)OpenAiService.execute(this.api.createThread(request));
    }

    public Thread retrieveThread(String threadId) {
        return (Thread)OpenAiService.execute(this.api.retrieveThread(threadId));
    }

    public Thread modifyThread(String threadId, ThreadRequest request) {
        return (Thread)OpenAiService.execute(this.api.modifyThread(threadId, request));
    }

    public DeleteResult deleteThread(String threadId) {
        return (DeleteResult)OpenAiService.execute(this.api.deleteThread(threadId));
    }

    public Message createMessage(String threadId, MessageRequest request) {
        return (Message)OpenAiService.execute(this.api.createMessage(threadId, request));
    }

    public Message retrieveMessage(String threadId, String messageId) {
        return (Message)OpenAiService.execute(this.api.retrieveMessage(threadId, messageId));
    }

    public Message modifyMessage(String threadId, String messageId, ModifyMessageRequest request) {
        return (Message)OpenAiService.execute(this.api.modifyMessage(threadId, messageId, request));
    }

    public OpenAiResponse<Message> listMessages(String threadId) {
        return (OpenAiResponse)OpenAiService.execute(this.api.listMessages(threadId));
    }

    public OpenAiResponse<Message> listMessages(String threadId, ListSearchParameters params) {
        Map queryParameters = (Map)mapper.convertValue((Object)params, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return (OpenAiResponse)OpenAiService.execute(this.api.listMessages(threadId, queryParameters));
    }

    public MessageFile retrieveMessageFile(String threadId, String messageId, String fileId) {
        return (MessageFile)OpenAiService.execute(this.api.retrieveMessageFile(threadId, messageId, fileId));
    }

    public OpenAiResponse<MessageFile> listMessageFiles(String threadId, String messageId) {
        return (OpenAiResponse)OpenAiService.execute(this.api.listMessageFiles(threadId, messageId));
    }

    public OpenAiResponse<MessageFile> listMessageFiles(String threadId, String messageId, ListSearchParameters params) {
        Map queryParameters = (Map)mapper.convertValue((Object)params, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return (OpenAiResponse)OpenAiService.execute(this.api.listMessageFiles(threadId, messageId, queryParameters));
    }

    public Run createRun(String threadId, RunCreateRequest runCreateRequest) {
        return (Run)OpenAiService.execute(this.api.createRun(threadId, runCreateRequest));
    }

    public Run retrieveRun(String threadId, String runId) {
        return (Run)OpenAiService.execute(this.api.retrieveRun(threadId, runId));
    }

    public static <T> T execute(Single<T> apiCall) {
        try {
            return (T)apiCall.blockingGet();
        }
        catch (HttpException e) {
            try {
                if (e.response() == null || e.response().errorBody() == null) {
                    throw e;
                }
                String errorBody = e.response().errorBody().string();
                OpenAiError error = (OpenAiError)mapper.readValue(errorBody, OpenAiError.class);
                throw new OpenAiHttpException(error, (Exception)((Object)e), e.code());
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall) {
        return OpenAiService.stream(apiCall, false);
    }

    public static Flowable<SSE> stream(Call<ResponseBody> apiCall, boolean emitDone) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new ResponseBodyCallback((FlowableEmitter<SSE>)emitter, emitDone)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public static <T> Flowable<T> stream(Call<ResponseBody> apiCall, Class<T> cl) {
        return OpenAiService.stream(apiCall).map(sse -> mapper.readValue(sse.getData(), cl));
    }

    public void shutdownExecutor() {
        Objects.requireNonNull(this.executorService, "executorService must be set in order to shut down");
        this.executorService.shutdown();
    }

    public static OpenAiApi buildApi(String token, Duration timeout) {
        ObjectMapper mapper = OpenAiService.defaultObjectMapper();
        OkHttpClient client = OpenAiService.defaultClient(token, timeout);
        Retrofit retrofit = OpenAiService.defaultRetrofit(client, mapper);
        return (OpenAiApi)retrofit.create(OpenAiApi.class);
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        mapper.addMixIn(ChatFunction.class, ChatFunctionMixIn.class);
        mapper.addMixIn(ChatCompletionRequest.class, ChatCompletionRequestMixIn.class);
        mapper.addMixIn(ChatFunctionCall.class, ChatFunctionCallMixIn.class);
        return mapper;
    }

    public static OkHttpClient defaultClient(String token, Duration timeout) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthenticationInterceptor(token)).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public static Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper) {
        return new Retrofit.Builder().baseUrl(BASE_URL).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }

    public Flowable<ChatMessageAccumulator> mapStreamToAccumulator(Flowable<ChatCompletionChunk> flowable) {
        ChatFunctionCall functionCall = new ChatFunctionCall(null, null);
        ChatMessage accumulatedMessage = new ChatMessage(ChatMessageRole.ASSISTANT.value(), null);
        return flowable.map(chunk -> {
            ChatMessage messageChunk = ((ChatCompletionChoice)chunk.getChoices().get(0)).getMessage();
            if (messageChunk.getFunctionCall() != null) {
                if (messageChunk.getFunctionCall().getName() != null) {
                    String namePart = messageChunk.getFunctionCall().getName();
                    functionCall.setName((functionCall.getName() == null ? "" : functionCall.getName()) + namePart);
                }
                if (messageChunk.getFunctionCall().getArguments() != null) {
                    String argumentsPart = messageChunk.getFunctionCall().getArguments() == null ? "" : messageChunk.getFunctionCall().getArguments().asText();
                    functionCall.setArguments((JsonNode)new TextNode((functionCall.getArguments() == null ? "" : functionCall.getArguments().asText()) + argumentsPart));
                }
                accumulatedMessage.setFunctionCall(functionCall);
            } else {
                accumulatedMessage.setContent((accumulatedMessage.getContent() == null ? "" : accumulatedMessage.getContent()) + (messageChunk.getContent() == null ? "" : messageChunk.getContent()));
            }
            if (((ChatCompletionChoice)chunk.getChoices().get(0)).getFinishReason() != null && functionCall.getArguments() != null) {
                functionCall.setArguments(mapper.readTree(functionCall.getArguments().asText()));
                accumulatedMessage.setFunctionCall(functionCall);
            }
            return new ChatMessageAccumulator(messageChunk, accumulatedMessage);
        });
    }

    public Subscription subscription() {
        Single subscription = this.api.subscription();
        return (Subscription)subscription.blockingGet();
    }

    public BillingUsage billingUsage(@NotNull LocalDate starDate, @NotNull LocalDate endDate) {
        Single billingUsage = this.api.billingUsage(starDate, endDate);
        return (BillingUsage)billingUsage.blockingGet();
    }
}

