/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.filter;

import com.cntaiping.fsc.common.config.CommonProperties;
import com.cntaiping.fsc.common.filter.AuditLog;
import com.cntaiping.fsc.common.util.Commons;
import com.cntaiping.fsc.core.util.SessionUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.filter.OrderedRequestContextFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class AuditLogRequestFilter
extends OrderedRequestContextFilter {
    private static final String LOGGER_KEY = "TP_AUDIT_LOG.AuditLogRequestFilter";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogRequestFilter.class);
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"TP_AUDIT_LOG.AuditLogRequestFilter");
    public static final int DEFAULT_ORDER = 50;
    public static final ArrayList<String> ALLOW_CONTENT_TYPE_LIST = Lists.newArrayList((Object[])new String[]{"/json", "/x-www-form-urlencoded", "/plain", "/xml"});
    private static final AuditLog DEFAULT_AUDIT_LOG = new AuditLog();
    private static final String REQUEST_HEADER_MENU = "X-MENU";
    private final List<String> staticFileExtensions = List.of(".css", ".js", ".png", ".jpg", ".log", ".html");
    private final AntPathMatcher pathMatcher;
    private final CommonProperties commonProperties;
    private int maxRequestPayloadLength = 0x100000;
    private int maxResponsePayloadLength = 0x100000;

    public AuditLogRequestFilter(CommonProperties commonProperties) {
        this.commonProperties = commonProperties;
        super.setOrder(50);
        this.pathMatcher = new AntPathMatcher();
        Integer maxResponsePayloadLength = commonProperties.getAuditLogMaxResponsePayloadLength();
        Integer maxRequestPayloadLength = commonProperties.getAuditLogMaxRequestPayloadLength();
        if (maxRequestPayloadLength != null) {
            this.maxRequestPayloadLength = maxRequestPayloadLength;
        }
        if (maxResponsePayloadLength != null) {
            this.maxResponsePayloadLength = maxResponsePayloadLength;
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String url;
        block15: {
            block14: {
                LOGGER.debug("doFilter AuditLogRequestFilter.");
                if (!this.enableAuditLog()) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (!this.isFromGateway(request)) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                url = request.getRequestURI();
                if (url.isEmpty()) break block14;
                if (!this.staticFileExtensions.stream().anyMatch(url::contains)) break block15;
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        AuditLog auditLog = this.auditLogs().stream().filter(log -> this.pathMatcher.match(log.getPath(), url)).findFirst().orElse(DEFAULT_AUDIT_LOG);
        if (!auditLog.isEnabled()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Exception exception = null;
        byte[] responseContent = new byte[]{};
        ContentCachingRequestWrapper request0 = new ContentCachingRequestWrapper(request);
        HttpServletResponse response0 = response;
        try {
            if (auditLog.isIncludeResponse()) {
                ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(response);
                response0 = responseWrapper;
                filterChain.doFilter((ServletRequest)request0, (ServletResponse)responseWrapper);
                responseContent = responseWrapper.getContentAsByteArray();
                responseWrapper.copyBodyToResponse();
            } else {
                filterChain.doFilter((ServletRequest)request0, (ServletResponse)response);
            }
        }
        catch (Exception e) {
            exception = e;
            throw e;
        }
        finally {
            this.doLog(request0, response0, auditLog, responseContent, exception);
        }
    }

    private boolean isFromGateway(HttpServletRequest request) {
        return request.getHeader("x-gateway-type") != null;
    }

    protected void doLog(ContentCachingRequestWrapper request, HttpServletResponse response, AuditLog auditLog, byte[] responseContent, Exception exception) {
        try {
            Map<String, Object> requestMessage = this.createRequestMessage(request, auditLog);
            Map<String, Object> responseMessage = this.createResponseMessage(response, responseContent, auditLog);
            if (exception != null) {
                AUDIT_LOGGER.info("Request: [{}]\nResponse: [{}]\nException: [{}]", new Object[]{requestMessage, responseMessage, exception.getLocalizedMessage()});
            } else {
                AUDIT_LOGGER.info("Request: [{}]\nResponse: [{}]", requestMessage, responseMessage);
            }
        }
        catch (Exception e) {
            LOGGER.error("AuditLogRequestFilter doLog ERROR!", (Throwable)e);
        }
    }

    protected Map<String, Object> createResponseMessage(HttpServletResponse response, byte[] responseContent, AuditLog auditLog) {
        String payload;
        LinkedHashMap logMessage = Maps.newLinkedHashMap();
        logMessage.put("status", response.getStatus());
        if (auditLog.isIncludeResponse() && (payload = this.getPayload(response.getContentType(), responseContent, "UTF-8", this.maxResponsePayloadLength)) != null) {
            logMessage.put("responsePayload", payload);
        }
        return logMessage;
    }

    protected Map<String, Object> createRequestMessage(ContentCachingRequestWrapper request, AuditLog auditLog) {
        String requestPayload;
        String queryString;
        LinkedHashMap logMessage = Maps.newLinkedHashMap();
        logMessage.put("method", request.getMethod());
        String menu = request.getHeader(REQUEST_HEADER_MENU);
        if (Commons.isNotEmpty(menu)) {
            logMessage.put("menu", menu);
        }
        StringBuilder urlBuilder = new StringBuilder(request.getRequestURI());
        if (this.isIncludeQueryString() && (queryString = request.getQueryString()) != null) {
            urlBuilder.append('?').append(queryString);
        }
        logMessage.put("url", urlBuilder.toString());
        if (this.isIncludeClientInfo()) {
            String remoteHost;
            String userCode;
            HttpSession session;
            String client = request.getRemoteAddr();
            if (StringUtils.hasLength((String)client)) {
                logMessage.put("client", client);
            }
            if ((session = request.getSession(false)) != null) {
                logMessage.put("sessionId", session.getId());
            }
            if ((userCode = SessionUtil.getUserCodeFromSession((HttpServletRequest)request)) != null) {
                logMessage.put("userCode", userCode);
            }
            if ((remoteHost = SessionUtil.getRemoteHost((HttpServletRequest)request)) != null) {
                logMessage.put("clientIp", remoteHost);
            }
        }
        logMessage.put("contentType", request.getContentType());
        if (auditLog.isIncludeRequest() && (requestPayload = this.getPayload(request.getContentType(), request.getContentAsByteArray(), request.getCharacterEncoding(), this.maxRequestPayloadLength)) != null) {
            logMessage.put("requestPayload", requestPayload);
        }
        return logMessage;
    }

    private boolean isIncludeClientInfo() {
        return true;
    }

    private boolean isIncludeQueryString() {
        return true;
    }

    @Nullable
    protected String getPayload(String contentType, byte[] payload, String charset, int maxLength) {
        block7: {
            block6: {
                if (contentType == null) break block6;
                if (!ALLOW_CONTENT_TYPE_LIST.stream().noneMatch(contentType::contains)) break block7;
            }
            return null;
        }
        if (payload.length > 0) {
            int length = Math.min(payload.length, maxLength);
            try {
                return new String(payload, 0, length, charset);
            }
            catch (UnsupportedEncodingException ex) {
                return "[unknown]";
            }
        }
        return null;
    }

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        if (this.auditLogs() == null) {
            throw new NullPointerException("app.common.auditLogs can not be null");
        }
        for (AuditLog auditLog : this.auditLogs()) {
            if (auditLog.getPath() != null) continue;
            throw new NullPointerException("auditLog.path can not be null");
        }
    }

    private boolean enableAuditLog() {
        return this.commonProperties.isEnableAuditLog();
    }

    private List<AuditLog> auditLogs() {
        return this.commonProperties.getAuditLogs() == null ? List.of() : this.commonProperties.getAuditLogs();
    }

    static {
        DEFAULT_AUDIT_LOG.setEnabled(false);
        DEFAULT_AUDIT_LOG.setIncludeResponse(false);
        DEFAULT_AUDIT_LOG.setPath("/");
    }
}

