/*
 * Decompiled with CFR 0.152.
 */
package com.tpstic.starter.oss.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.tpstic.starter.oss.properties.AliyunOssProperties;
import java.io.File;
import java.io.InputStream;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AliyunOssUtils {
    public static final Logger log = LoggerFactory.getLogger(AliyunOssUtils.class);
    public static final String SPLIT_PATH = "/";
    @Autowired
    AliyunOssProperties aliyunOssProperties;
    private OSSClient ossClient;

    public AliyunOssUtils(OSSClient ossClient) {
        this.ossClient = ossClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getOssInputStream(String objectName) {
        this.logInfoObjectName(objectName);
        InputStream inputStream = null;
        try {
            OSSObject ossObject = this.ossClient.getObject(this.aliyunOssProperties.getBucketName(), objectName);
            inputStream = ossObject.getObjectContent();
        }
        catch (Exception e) {
            log.error("oss\u6587\u4ef6\u6d41\u4e0b\u8f7d\u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            this.ossShutdown(this.ossClient);
        }
        return inputStream;
    }

    private String generatorObjectName(String fileName) {
        boolean includeSplitPath;
        boolean bl = includeSplitPath = fileName.indexOf(SPLIT_PATH) > 0;
        if (!includeSplitPath) {
            fileName = this.getDefaultFilePrefix() + fileName;
        }
        return fileName;
    }

    public String getDefaultFilePrefix() {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        DateTimeFormatter forPattern = DateTimeFormat.forPattern((String)"yyyy/MM/dd");
        String dirName = forPattern.print((ReadableInstant)new DateTime());
        String defaultFilePrefixPath = dirName + SPLIT_PATH + uuid;
        return defaultFilePrefixPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pushFileToOSS(String localFile, String objectName) {
        this.logInfoObjectName(objectName);
        String callbackOssPath = null;
        try {
            objectName = this.generatorObjectName(objectName);
            File file = new File(localFile);
            this.ossClient.putObject(this.aliyunOssProperties.getBucketName(), objectName, file);
            callbackOssPath = this.aliyunOssProperties.getWlanInternel() + objectName;
        }
        catch (Exception e) {
            log.error("oss\u4e0a\u4f20\u5931\u8d25:", (Throwable)e);
        }
        finally {
            this.ossShutdown(this.ossClient);
        }
        return callbackOssPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pushInputStreamToOSS(InputStream inputStream, String objectName) {
        this.logInfoObjectName(objectName);
        String callbackOssPath = null;
        try {
            objectName = this.generatorObjectName(objectName);
            this.ossClient.putObject(this.aliyunOssProperties.getBucketName(), objectName, inputStream);
            callbackOssPath = this.aliyunOssProperties.getWlanInternel() + objectName;
        }
        catch (Exception e) {
            log.error("oss\u4e0a\u4f20\u5931\u8d25:", (Throwable)e);
        }
        finally {
            this.ossShutdown(this.ossClient);
        }
        return callbackOssPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean fileExist(String objectName) {
        this.logInfoObjectName(objectName);
        boolean flag = true;
        try {
            String name = objectName.replaceAll(this.aliyunOssProperties.getWlanInternel(), "");
            flag = this.ossClient.doesObjectExist(this.aliyunOssProperties.getBucketName(), name);
        }
        catch (Exception e) {
            log.error("oss\u4e0a\u4f20\u5931\u8d25:", (Throwable)e);
        }
        finally {
            this.ossShutdown(this.ossClient);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean deleteFile(String objectName) {
        this.logInfoObjectName(objectName);
        boolean flag = true;
        try {
            String name = objectName.replaceAll(this.aliyunOssProperties.getWlanInternel(), "");
            this.ossClient.deleteObject(this.aliyunOssProperties.getBucketName(), name);
        }
        catch (Exception e) {
            log.error("oss\u5220\u9664\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
            flag = false;
        }
        finally {
            this.ossShutdown(this.ossClient);
        }
        return flag;
    }

    private void logInfoObjectName(String objectName) {
        log.info("objectName:{}", (Object)objectName);
    }

    private void ossShutdown(OSSClient ossClient) {
        if (ossClient != null) {
            ossClient.shutdown();
        }
    }
}

