/*
 * Decompiled with CFR 0.152.
 */
package cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PowerCacheManager {
    private static Log logger = LogFactory.getLog(PowerCacheManager.class);
    private static Map<String, Object> powerAllCacheMap = new HashMap<String, Object>(0);
    private Map<String, Object> powerCacheMap = new HashMap<String, Object>(0);
    private String cacheName;
    private Object lockObject = new Object();

    private PowerCacheManager(String cacheName) {
        this.cacheName = cacheName;
    }

    public static void main(String[] args) {
    }

    public static PowerCacheManager getIntance(String cacheName) {
        if (powerAllCacheMap.containsKey(cacheName)) {
            return (PowerCacheManager)powerAllCacheMap.get(cacheName);
        }
        PowerCacheManager powerCacheManager = new PowerCacheManager(cacheName);
        powerAllCacheMap.put(cacheName, powerCacheManager);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Create cacheManager " + cacheName));
        }
        return powerCacheManager;
    }

    public static String[] getAllCacheName() {
        Object[] keyArray = powerAllCacheMap.keySet().toArray();
        String[] nameArray = new String[keyArray.length];
        int i = 0;
        while (i < keyArray.length) {
            nameArray[i] = (String)keyArray[i];
            ++i;
        }
        return nameArray;
    }

    public static synchronized void clearAllCacheManager() {
        String[] cacheNameArray = PowerCacheManager.getAllCacheName();
        int i = 0;
        while (i < cacheNameArray.length) {
            PowerCacheManager.getIntance(cacheNameArray[i]).clearCache(new Object[0]);
            ++i;
        }
    }

    public Object getCache(String key) {
        Object value = this.powerCacheMap.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieve data key=" + key + ",value=" + value));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCache(String key, Object value) {
        Object object = this.lockObject;
        synchronized (object) {
            this.powerCacheMap.put(key, value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Put cache key=" + key + ",value=" + value));
            }
        }
    }

    public synchronized void clearCache(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            int size = this.powerCacheMap.size();
            this.powerCacheMap.clear();
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Clear " + this.cacheName + " total " + size + " item(s)."));
            }
            return;
        }
        String keyPrefix = this.generateKey(arguments);
        String keyName = "";
        Object[] keys = this.powerCacheMap.keySet().toArray();
        int size = 0;
        int i = 0;
        while (i < keys.length) {
            keyName = (String)keys[i];
            if (keyName != null && keyName.startsWith(keyPrefix)) {
                this.powerCacheMap.remove(keyName);
                ++size;
            }
            ++i;
        }
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Clear " + this.cacheName + " " + size + " item(s).prefix=" + keyPrefix));
        }
    }

    public synchronized void clear(String userCode) {
        String keyName = "";
        Object[] keys = this.powerCacheMap.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            keyName = (String)keys[i];
            if (keyName != null && keyName.indexOf(userCode) > -1) {
                this.powerCacheMap.remove(keyName);
                logger.info((Object)("\u6e05\u9664Cache Key " + keyName));
            }
            ++i;
        }
        logger.info((Object)("\u6e05\u9664\u7528\u6237" + userCode + "\u5728\u6743\u9650\u4e2d\u7684Cache"));
    }

    public boolean containsKey(String key) {
        return this.powerCacheMap.containsKey(key);
    }

    public boolean containsValue(String value) {
        return this.powerCacheMap.containsValue(value);
    }

    public String generateCacheKey(Object ... arguments) {
        if (arguments != null && arguments.length > 0) {
            return this.generateKey(arguments);
        }
        return null;
    }

    private String generateKey(Object ... arguments) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < arguments.length) {
            sb.append(".").append(arguments[i]);
            ++i;
        }
        return sb.toString();
    }
}

