/*
 * Decompiled with CFR 0.152.
 */
package cn.com.sinosoft.saa.service.facade;

import cache.PowerCacheManager;
import cn.com.sinosoft.saa.exception.BusinessException;
import cn.com.sinosoft.saa.service.facade.ArrayOfString;
import cn.com.sinosoft.saa.service.facade.PowerServerGet;
import cn.com.sinosoft.saa.service.facade.SaaPowerServiceClient;
import ins.platform.menu.service.facade.MenuServiceClient;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerBean {
    private static SaaPowerServiceClient powerClient;
    private static MenuServiceClient menuClient;
    private static PowerCacheManager cacheManagerPowerBean;

    static {
        cacheManagerPowerBean = PowerCacheManager.getIntance("PowerBean");
    }

    private PowerBean() {
    }

    public static void setPowerMenuServerURL(String ipAddress, String port) {
        if (ipAddress.equals("") || ipAddress == null || port.equals("") || port == null) {
            throw new BusinessException("\u6743\u9650\u83dc\u5355\u670d\u52a1IP\u5730\u5740\u548c\u7aef\u53e3\u4e0d\u53ef\u4e3a\u7a7a\uff01", false);
        }
        String serverIP = String.valueOf(ipAddress.trim()) + ":" + port.trim();
        PowerServerGet.setServerIP(serverIP);
    }

    public static void clearMemory() {
        PowerCacheManager.clearAllCacheManager();
    }

    public static void clear(String userCode) {
        cacheManagerPowerBean.clear(userCode);
    }

    public static boolean checkPower(String userCode, String taskCode, int powerType, String gradesIdString) {
        powerClient = new SaaPowerServiceClient();
        String key = cacheManagerPowerBean.generateCacheKey("checkPower", userCode, taskCode, powerType);
        Object result = cacheManagerPowerBean.getCache(key);
        System.out.println("result" + result);
        try {
            if (result != null) {
                System.out.println("cache\u7684\u503c");
                return (Boolean)result;
            }
            boolean powerCheck = powerClient.getSaaPowerServiceHttpPort().checkPower(userCode, taskCode, powerType, gradesIdString);
            cacheManagerPowerBean.putCache(key, powerCheck);
            System.out.println("\u4ece\u7f13\u5b58\u4e2d\u53d6\u6570\uff1a" + cacheManagerPowerBean.getCache(key));
            return powerCheck;
        }
        catch (Exception e) {
            throw new BusinessException("\u6743\u9650checkPower\u5f02\u5e38\uff01", false);
        }
    }

    public static String addPower(String userCode, String taskCode, String userCodeFields, String companyCodeFields, String riskCodeFields, String gradesIdString) {
        powerClient = new SaaPowerServiceClient();
        String key = cacheManagerPowerBean.generateCacheKey("addPower", userCode, taskCode, userCodeFields, companyCodeFields, riskCodeFields, gradesIdString);
        Object result = cacheManagerPowerBean.getCache(key);
        if (result != null) {
            return (String)result;
        }
        String powerAdd = powerClient.getSaaPowerServiceHttpPort().addPower(userCode, taskCode, userCodeFields, companyCodeFields, riskCodeFields, gradesIdString);
        cacheManagerPowerBean.putCache(key, powerAdd);
        return powerAdd;
    }

    public static String addAuthPower(String userCode, String userCodeFields, String companyCodeFields, String riskCodeFields, String adminFlag) {
        powerClient = new SaaPowerServiceClient();
        String key = cacheManagerPowerBean.generateCacheKey("addAuthPower", userCode, userCodeFields, companyCodeFields, riskCodeFields, adminFlag);
        Object result = cacheManagerPowerBean.getCache(key);
        if (result != null) {
            return (String)result;
        }
        ArrayOfString strings = new ArrayOfString();
        strings.getString().add(userCode);
        strings.getString().add(userCodeFields);
        strings.getString().add(companyCodeFields);
        strings.getString().add(riskCodeFields);
        strings.getString().add(adminFlag);
        String powerAddAuth = powerClient.getSaaPowerServiceHttpPort().addAuthPower(strings);
        cacheManagerPowerBean.putCache(key, powerAddAuth);
        return powerAddAuth;
    }

    public static List<String> getInsteadUserList(String userCode) {
        powerClient = new SaaPowerServiceClient();
        return PowerBean.powerClient.getSaaPowerServiceHttpPort().getInsteadUserList((String)userCode).string;
    }

    public static String getInsteadGradesIdString(String userCode, String insteadUserCode) {
        powerClient = new SaaPowerServiceClient();
        return powerClient.getSaaPowerServiceHttpPort().getInsteadGradesIdString(userCode, insteadUserCode);
    }

    public static void login(String userCode, String password) {
        powerClient = new SaaPowerServiceClient();
        powerClient.getSaaPowerServiceHttpPort().login(userCode, password);
        cacheManagerPowerBean.clear(userCode);
    }

    public static String showMenu(Integer upperMenuId, String comCode, String userCode, String gradeCodes, String systemCode, String menuStyle, String language, int powerType, String gradesIdString) {
        menuClient = new MenuServiceClient();
        String key = cacheManagerPowerBean.generateCacheKey("showMenu", upperMenuId, userCode, systemCode, menuStyle, language, powerType, gradesIdString);
        String menuContent = null;
        Object result = cacheManagerPowerBean.getCache(key);
        try {
            if (result != null) {
                return (String)result;
            }
            menuContent = menuClient.getMenuServiceHttpPort().showMenu(upperMenuId, comCode, userCode, gradeCodes, systemCode, menuStyle, language, powerType, gradesIdString);
            cacheManagerPowerBean.putCache(key, menuContent);
            return menuContent;
        }
        catch (Exception e) {
            return menuContent;
        }
    }

    public static String showMenuWithRisk(Integer upperMenuId, String comCode, String userCode, String gradeCodes, String systemCode, String riskCode, String menuStyle, String language, int powerType, String gradesIdString) {
        menuClient = new MenuServiceClient();
        String key = cacheManagerPowerBean.generateCacheKey("showMenuWithRisk", upperMenuId, userCode, systemCode, riskCode, menuStyle, language, powerType, gradesIdString);
        String menuContent = null;
        Object result = cacheManagerPowerBean.getCache(key);
        try {
            if (result != null) {
                return (String)result;
            }
            menuContent = menuClient.getMenuServiceHttpPort().showMenu1(upperMenuId, comCode, userCode, gradeCodes, systemCode, riskCode, menuStyle, language, powerType, gradesIdString);
            cacheManagerPowerBean.putCache(key, menuContent);
            return menuContent;
        }
        catch (Exception e) {
            return menuContent;
        }
    }

    public static List<String> getPrimUserCodeList(String taskCode, String comCode, String riskCode) {
        powerClient = new SaaPowerServiceClient();
        String key = cacheManagerPowerBean.generateCacheKey("getPrimUserCodeList", taskCode, comCode, riskCode);
        Object result = cacheManagerPowerBean.getCache(key);
        if (result != null) {
            return (List)result;
        }
        List<Object> strings = new ArrayList();
        strings = PowerBean.powerClient.getSaaPowerServiceHttpPort().getPowerUser((String)taskCode, (String)comCode, (String)riskCode).string;
        if (strings.get(0) != null) {
            return strings;
        }
        return null;
    }

    public static List<String> getPowerComList(String userCode, String taskCode) {
        powerClient = new SaaPowerServiceClient();
        String key = cacheManagerPowerBean.generateCacheKey("getPowerComList", userCode, taskCode);
        Object result = cacheManagerPowerBean.getCache(key);
        if (result != null) {
            return (List)result;
        }
        List<Object> strings = new ArrayList();
        strings = PowerBean.powerClient.getSaaPowerServiceHttpPort().getPowerComList((String)userCode, (String)taskCode).string;
        if (strings.get(0) != null) {
            return strings;
        }
        return null;
    }

    public static List<String> findUserTaskCodeByNote(String userCode, String note) {
        powerClient = new SaaPowerServiceClient();
        String key = cacheManagerPowerBean.generateCacheKey("findUserTaskCodeByNote", userCode, note);
        Object result = cacheManagerPowerBean.getCache(key);
        if (result != null) {
            return (List)result;
        }
        List<Object> strings = new ArrayList();
        strings = PowerBean.powerClient.getSaaPowerServiceHttpPort().findUserTaskCodeByNote((String)userCode, (String)note).string;
        if (strings != null) {
            return strings;
        }
        strings.add(null);
        return strings;
    }
}

