/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal.active;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.activeio.journal.active.JournalLockedException;
import org.apache.activeio.packet.ByteBufferPacket;
import org.apache.activeio.packet.Packet;

public final class ControlFile {
    private final RandomAccessFile file;
    private final FileChannel channel;
    private final ByteBufferPacket controlData;
    private static final boolean brokenFileLock = "true".equals(System.getProperty("java.nio.channels.FileLock.broken", "false"));
    private static final boolean disableLocking = "true".equals(System.getProperty("org.apache.activeio.journal.active.DisableLocking", "false"));
    private long controlDataVersion = 0L;
    private FileLock lock;
    private boolean disposed;
    private static Set lockSet;
    private String canonicalPath;

    public ControlFile(File fileName, int controlDataSize) throws IOException {
        this.canonicalPath = fileName.getCanonicalPath();
        boolean existed = fileName.exists();
        this.file = new RandomAccessFile(fileName, "rw");
        this.channel = this.file.getChannel();
        this.controlData = new ByteBufferPacket(ByteBuffer.allocateDirect(controlDataSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws IOException {
        Set set;
        if (disableLocking) {
            return;
        }
        Set set2 = set = ControlFile.getVmLockSet();
        synchronized (set2) {
            if (this.lock == null) {
                if (!set.add(this.canonicalPath)) {
                    throw new JournalLockedException("Journal is already opened by this application.");
                }
                if (!brokenFileLock) {
                    this.lock = this.channel.tryLock();
                    if (this.lock == null) {
                        set.remove(this.canonicalPath);
                        throw new JournalLockedException("Journal is already opened by another application");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws IOException {
        Set set;
        if (disableLocking) {
            return;
        }
        Set set2 = set = ControlFile.getVmLockSet();
        synchronized (set2) {
            if (this.lock != null) {
                set.remove(this.canonicalPath);
                this.lock.release();
                this.lock = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getVmLockSet() {
        if (lockSet == null) {
            Properties properties;
            Properties properties2 = properties = System.getProperties();
            synchronized (properties2) {
                lockSet = (Set)properties.get("org.apache.activeio.journal.active.lockMap");
                if (lockSet == null) {
                    lockSet = new HashSet();
                }
                properties.put("org.apache.activeio.journal.active.lockMap", lockSet);
            }
        }
        return lockSet;
    }

    public boolean load() throws IOException {
        long l = this.file.length();
        if (l < (long)this.controlData.capacity()) {
            this.controlDataVersion = 0L;
            this.controlData.position(0);
            this.controlData.limit(0);
            return false;
        }
        this.file.seek(0L);
        long v1 = this.file.readLong();
        this.file.seek(this.controlData.capacity() + 8);
        long v1check = this.file.readLong();
        this.file.seek(this.controlData.capacity() + 16);
        long v2 = this.file.readLong();
        this.file.seek(this.controlData.capacity() * 2 + 24);
        long v2check = this.file.readLong();
        if (v2 == v2check) {
            this.controlDataVersion = v2;
            this.file.seek(this.controlData.capacity() + 24);
            this.controlData.clear();
            this.channel.read(this.controlData.getByteBuffer());
        } else if (v1 == v1check) {
            this.controlDataVersion = v1;
            this.file.seek(this.controlData.capacity() + 8);
            this.controlData.clear();
            this.channel.read(this.controlData.getByteBuffer());
        } else {
            throw new IOException("Control data corrupted.");
        }
        return true;
    }

    public void store() throws IOException {
        ++this.controlDataVersion;
        this.file.setLength(this.controlData.capacity() * 2 + 32);
        this.file.seek(0L);
        this.file.writeLong(this.controlDataVersion);
        this.controlData.clear();
        this.channel.write(this.controlData.getByteBuffer());
        this.file.writeLong(this.controlDataVersion);
        this.file.writeLong(this.controlDataVersion);
        this.controlData.clear();
        this.channel.write(this.controlData.getByteBuffer());
        this.file.writeLong(this.controlDataVersion);
        this.channel.force(false);
    }

    public Packet getControlData() {
        this.controlData.clear();
        return this.controlData;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        try {
            this.unlock();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

