/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import javax.jms.JMSException;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkBridgeFilter
implements DataStructure,
BooleanExpression {
    static final Log log = LogFactory.getLog(NetworkBridgeFilter.class);
    public static final byte DATA_STRUCTURE_TYPE = 91;
    private BrokerId networkBrokerId;
    private int networkTTL;

    public NetworkBridgeFilter() {
    }

    public NetworkBridgeFilter(BrokerId remoteBrokerPath, int networkTTL) {
        this.networkBrokerId = remoteBrokerPath;
        this.networkTTL = networkTTL;
    }

    public byte getDataStructureType() {
        return 91;
    }

    public boolean isMarshallAware() {
        return false;
    }

    public boolean matches(MessageEvaluationContext message) throws JMSException {
        try {
            return this.matchesForwardingFilter(message.getMessage());
        }
        catch (IOException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public Object evaluate(MessageEvaluationContext message) throws JMSException {
        return this.matches(message) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean matchesForwardingFilter(Message message) {
        int hops;
        if (NetworkBridgeFilter.contains(message.getBrokerPath(), this.networkBrokerId)) {
            if (log.isTraceEnabled()) {
                log.trace("Message all ready routed once through this broker - ignoring: " + message);
            }
            return false;
        }
        int n = hops = message.getBrokerPath() == null ? 0 : message.getBrokerPath().length;
        if (hops >= this.networkTTL) {
            if (log.isTraceEnabled()) {
                log.trace("Message restricted to " + this.networkTTL + " network hops ignoring: " + message);
            }
            return false;
        }
        if (message.isAdvisory() && message.getDataStructure() != null && message.getDataStructure().getDataStructureType() == 5) {
            ConsumerInfo info = (ConsumerInfo)message.getDataStructure();
            int n2 = hops = info.getBrokerPath() == null ? 0 : message.getBrokerPath().length;
            if (hops >= this.networkTTL) {
                if (log.isTraceEnabled()) {
                    log.trace("ConsumerInfo advisory restricted to " + this.networkTTL + " network hops ignoring: " + message);
                }
                return false;
            }
        }
        return true;
    }

    public static boolean contains(BrokerId[] brokerPath, BrokerId brokerId) {
        if (brokerPath != null) {
            for (int i = 0; i < brokerPath.length; ++i) {
                if (!brokerId.equals(brokerPath[i])) continue;
                return true;
            }
        }
        return false;
    }

    public int getNetworkTTL() {
        return this.networkTTL;
    }

    public void setNetworkTTL(int networkTTL) {
        this.networkTTL = networkTTL;
    }

    public BrokerId getNetworkBrokerId() {
        return this.networkBrokerId;
    }

    public void setNetworkBrokerId(BrokerId remoteBrokerPath) {
        this.networkBrokerId = remoteBrokerPath;
    }
}

