/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.filter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.console.filter.AbstractQueryFilter;

public class MessagesQueryFilter
extends AbstractQueryFilter {
    private JMXServiceURL jmxServiceUrl;
    private ObjectName destName;

    public MessagesQueryFilter(JMXServiceURL jmxServiceUrl, ObjectName destName) {
        super(null);
        this.jmxServiceUrl = jmxServiceUrl;
        this.destName = destName;
    }

    public List query(List queries) throws Exception {
        String selector = "";
        Iterator i = queries.iterator();
        while (i.hasNext()) {
            selector = selector + "(" + i.next().toString() + ") AND ";
        }
        if (selector != "") {
            selector = selector.substring(0, selector.length() - 5);
        }
        return this.queryMessages(selector);
    }

    protected List queryMessages(String selector) throws Exception {
        JMXConnector connector = this.createJmxConnector();
        MBeanServerConnection server = connector.getMBeanServerConnection();
        CompositeData[] messages = (CompositeData[])server.invoke(this.destName, "browse", new Object[0], new String[0]);
        connector.close();
        return Arrays.asList(messages);
    }

    public JMXServiceURL getJmxServiceUrl() {
        return this.jmxServiceUrl;
    }

    public void setJmxServiceUrl(JMXServiceURL jmxServiceUrl) {
        this.jmxServiceUrl = jmxServiceUrl;
    }

    public void setJmxServiceUrl(String jmxServiceUrl) throws MalformedURLException {
        this.setJmxServiceUrl(new JMXServiceURL(jmxServiceUrl));
    }

    protected JMXConnector createJmxConnector() throws IOException {
        return JMXConnectorFactory.connect(this.getJmxServiceUrl());
    }
}

