/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import java.io.StringReader;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.XPathExpression;
import org.apache.activemq.util.ByteArrayInputStream;
import org.xml.sax.InputSource;

public class JAXPXPathEvaluator
implements XPathExpression.XPathEvaluator {
    private static final XPathFactory factory = XPathFactory.newInstance();
    private XPathExpression expression;

    public JAXPXPathEvaluator(String xpathExpression) {
        try {
            XPath xpath = factory.newXPath();
            this.expression = xpath.compile(xpathExpression);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Invalid XPath expression: " + xpathExpression);
        }
    }

    public boolean evaluate(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            String text = ((TextMessage)((Object)message)).getText();
            return this.evaluate(text);
        }
        if (message instanceof BytesMessage) {
            BytesMessage bm = (BytesMessage)((Object)message);
            byte[] data = new byte[(int)bm.getBodyLength()];
            bm.readBytes(data);
            return this.evaluate(data);
        }
        return false;
    }

    private boolean evaluate(byte[] data) {
        try {
            InputSource inputSource = new InputSource(new ByteArrayInputStream(data));
            return (Boolean)this.expression.evaluate(inputSource, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e) {
            return false;
        }
    }

    private boolean evaluate(String text) {
        try {
            InputSource inputSource = new InputSource(new StringReader(text));
            return (Boolean)this.expression.evaluate(inputSource, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e) {
            return false;
        }
    }
}

