/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.jaas.JaasCertificateCallbackHandler;
import org.apache.activemq.jaas.UserPrincipal;
import org.apache.activemq.security.JaasAuthenticationBroker;
import org.apache.activemq.security.JaasCertificateSecurityContext;

public class JaasCertificateAuthenticationBroker
extends BrokerFilter {
    private final String jaasConfiguration;

    public JaasCertificateAuthenticationBroker(Broker next, String jaasConfiguration) {
        super(next);
        this.jaasConfiguration = jaasConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        if (context.getSecurityContext() == null) {
            if (!(info.getTransportContext() instanceof X509Certificate[])) {
                throw new SecurityException("Unable to authenticate transport without SSL certificate.");
            }
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(JaasAuthenticationBroker.class.getClassLoader());
            try {
                try {
                    JaasCertificateCallbackHandler callback = new JaasCertificateCallbackHandler((X509Certificate[])info.getTransportContext());
                    LoginContext lc = new LoginContext(this.jaasConfiguration, callback);
                    lc.login();
                    Subject subject = lc.getSubject();
                    String dnName = "";
                    Iterator<Principal> iter = subject.getPrincipals().iterator();
                    while (iter.hasNext()) {
                        Principal nextPrincipal = iter.next();
                        if (!(nextPrincipal instanceof UserPrincipal)) continue;
                        dnName = ((UserPrincipal)nextPrincipal).getName();
                        break;
                    }
                    JaasCertificateSecurityContext s = new JaasCertificateSecurityContext(dnName, subject, (X509Certificate[])info.getTransportContext());
                    context.setSecurityContext(s);
                }
                catch (Exception e) {
                    throw new SecurityException("User name or password is invalid: " + e.getMessage(), e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        super.addConnection(context, info);
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        super.removeConnection(context, info, error);
        context.setSecurityContext(null);
    }
}

