/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportLogger;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.http.HttpClientTransport;
import org.apache.activemq.transport.http.HttpTransportServer;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.transport.xstream.XStreamWireFormat;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpTransportFactory
extends TransportFactory {
    private static final Log log = LogFactory.getLog(HttpTransportFactory.class);

    public TransportServer doBind(String brokerId, URI location) throws IOException {
        return new HttpTransportServer(location);
    }

    protected TextWireFormat asTextWireFormat(WireFormat wireFormat) {
        if (wireFormat instanceof TextWireFormat) {
            return (TextWireFormat)wireFormat;
        }
        log.trace("Not created with a TextWireFormat: " + wireFormat);
        return new XStreamWireFormat();
    }

    protected String getDefaultWireFormatType() {
        return "xstream";
    }

    protected Transport createTransport(URI location, WireFormat wf) throws IOException {
        TextWireFormat textWireFormat = this.asTextWireFormat(wf);
        return new HttpClientTransport(textWireFormat, location);
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        HttpClientTransport httpTransport = (HttpClientTransport)super.compositeConfigure(transport, format, options);
        transport = httpTransport;
        if (httpTransport.isTrace()) {
            transport = new TransportLogger(httpTransport);
        }
        return transport;
    }
}

