/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.asm;

import org.aspectj.apache.bcel.classfile.GenericSignatureParser;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.AnnotationsForMemberHolder;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.asm.AsmDelegate;
import org.aspectj.weaver.bcel.BcelGenericSignatureToTypeXConverter;

public class AsmField
extends ResolvedMemberImpl {
    private AsmDelegate classDelegate;
    private AnnotationsForMemberHolder annos;
    private String genericSignature = null;
    private boolean unpackedGenericSignature = false;
    private UnresolvedType genericFieldType = null;

    public void setClassDelegate(AsmDelegate del) {
        this.classDelegate = del;
    }

    public void setGenericSignature(String sig) {
        this.genericSignature = sig;
    }

    public AsmField(Member.Kind kind, UnresolvedType declaringType, int modifiers, String name, String signature) {
        super(kind, declaringType, modifiers, name, signature);
    }

    public UnresolvedType getGenericReturnType() {
        this.unpackGenericSignature();
        return this.genericFieldType;
    }

    private void unpackGenericSignature() {
        if (this.unpackedGenericSignature) {
            return;
        }
        if (!this.classDelegate.getWorld().isInJava5Mode()) {
            this.genericFieldType = this.getReturnType();
            return;
        }
        this.unpackedGenericSignature = true;
        String gSig = this.genericSignature;
        if (gSig != null) {
            Signature.FieldTypeSignature fts = new GenericSignatureParser().parseAsFieldSignature(gSig);
            Signature.FormalTypeParameter[] parentFormals = this.classDelegate.getAllFormals();
            Signature.FormalTypeParameter[] typeVars = parentFormals == null ? new Signature.FormalTypeParameter[]{} : parentFormals;
            Signature.FormalTypeParameter[] formals = new Signature.FormalTypeParameter[parentFormals.length + typeVars.length];
            System.arraycopy(typeVars, 0, formals, 0, typeVars.length);
            System.arraycopy(parentFormals, 0, formals, typeVars.length, parentFormals.length);
            try {
                this.genericFieldType = BcelGenericSignatureToTypeXConverter.fieldTypeSignature2TypeX(fts, formals, this.classDelegate.getWorld());
            }
            catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                throw new IllegalStateException("While determing the generic field type of " + this.toString() + " with generic signature " + gSig + " the following error was detected: " + e.getMessage());
            }
        } else {
            this.genericFieldType = this.getReturnType();
        }
    }

    public void addAnAnnotation(AnnotationAJ oneAnnotation) {
        if (this.annos == null) {
            this.annos = new AnnotationsForMemberHolder(this.classDelegate.getWorld());
        }
        this.annos.addAnnotation(oneAnnotation);
    }

    public AnnotationX[] getAnnotations() {
        if (this.annos == null) {
            return AnnotationX.NONE;
        }
        return this.annos.getAnnotations();
    }

    public ResolvedType[] getAnnotationTypes() {
        if (this.annos == null) {
            return ResolvedType.NONE;
        }
        return this.annos.getAnnotationTypes();
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        if (this.annos == null) {
            return false;
        }
        return this.annos.hasAnnotation(ofType);
    }
}

