/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.comparators.ComparableComparator;

public class BeanComparator
implements Comparator,
Serializable {
    private String property;
    private Comparator comparator;

    public BeanComparator() {
        this(null);
    }

    public BeanComparator(String string) {
        this(string, (Comparator)ComparableComparator.getInstance());
    }

    public BeanComparator(String string, Comparator comparator) {
        this.setProperty(string);
        this.comparator = comparator;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public String getProperty() {
        return this.property;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public int compare(Object object, Object object2) {
        if (this.property == null) {
            return this.comparator.compare(object, object2);
        }
        try {
            Object object3 = PropertyUtils.getProperty(object, this.property);
            Object object4 = PropertyUtils.getProperty(object2, this.property);
            return this.comparator.compare(object3, object4);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("IllegalAccessException: " + illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("InvocationTargetException: " + invocationTargetException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("NoSuchMethodException: " + noSuchMethodException.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BeanComparator)) {
            return false;
        }
        BeanComparator beanComparator = (BeanComparator)object;
        if (!((Object)this.comparator).equals(beanComparator.comparator)) {
            return false;
        }
        if (this.property != null) {
            return this.property.equals(beanComparator.property);
        }
        return beanComparator.property == null;
    }

    public int hashCode() {
        int n = this.comparator.hashCode();
        return n;
    }
}

