/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class BooleanConverter
implements Converter {
    public static final Object NO_DEFAULT = new Object();
    private Object defaultValue;
    private boolean useDefault;
    private String[] trueStrings = new String[]{"yes", "y", "true", "on", "1"};
    private String[] falseStrings = new String[]{"no", "n", "false", "off", "0"};

    public BooleanConverter() {
        this.useDefault = false;
    }

    public BooleanConverter(Object defaultValue) {
        if (defaultValue == NO_DEFAULT) {
            this.useDefault = false;
        } else {
            this.defaultValue = defaultValue;
            this.useDefault = true;
        }
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings, Object defaultValue) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
        if (defaultValue == NO_DEFAULT) {
            this.useDefault = false;
        } else {
            this.defaultValue = defaultValue;
            this.useDefault = true;
        }
    }

    public Object convert(Class type, Object value) {
        int i;
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof Boolean) {
            return value;
        }
        String stringValue = value.toString().toLowerCase();
        for (i = 0; i < this.trueStrings.length; ++i) {
            if (!this.trueStrings[i].equals(stringValue)) continue;
            return Boolean.TRUE;
        }
        for (i = 0; i < this.falseStrings.length; ++i) {
            if (!this.falseStrings[i].equals(stringValue)) continue;
            return Boolean.FALSE;
        }
        if (this.useDefault) {
            return this.defaultValue;
        }
        throw new ConversionException(value.toString());
    }

    private static String[] copyStrings(String[] src) {
        String[] dst = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i].toLowerCase();
        }
        return dst;
    }
}

