/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public final class SqlDateConverter
implements Converter {
    private Object defaultValue = null;
    private boolean useDefault = true;

    public SqlDateConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public SqlDateConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof java.sql.Date) {
            return value;
        }
        if (value instanceof Date) {
            return new java.sql.Date(((Date)value).getTime());
        }
        if (value instanceof Calendar) {
            return new java.sql.Date(((Calendar)value).getTime().getTime());
        }
        try {
            return java.sql.Date.valueOf(value.toString());
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(e);
        }
    }
}

