/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.lucene.index.TransLog;
import org.apache.lucene.store.ConfigurableBufferedIndexInput;
import org.apache.lucene.store.ConfigurableBufferedIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.util.LuceneUtils;

public class FSTransLog
implements TransLog {
    private TransDirectory dir;
    private static Random transId = new Random();
    private static final String DEFAULT_LOCATION = System.getProperty("java.io.tmpdir") + "/compass/translog";

    public void configure(CompassSettings settings) throws CompassException {
        String location = settings.getSetting("compass.transaction.translog.path", DEFAULT_LOCATION);
        int readBufferSize = settings.getSettingAsInt("compass.transaction.translog.readBufferSize", 64);
        int writeBufferSize = settings.getSettingAsInt("compass.transaction.translog.writeBufferSize", 2048);
        try {
            location = location + "/" + transId.nextLong();
            this.dir = new TransDirectory(location, writeBufferSize, readBufferSize);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to create tran log location [" + location + "]");
        }
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public boolean shouldUpdateTransSegments() {
        return false;
    }

    public void close() throws IOException {
        this.dir.close();
        LuceneUtils.deleteDir(this.dir.getFile());
        this.dir = null;
    }

    public void onDocumentAdded() throws IOException {
        this.dir.flush();
    }

    class TransDirectory
    extends Directory {
        private RandomAccessFile raf;
        private HashMap files;
        private File dir;
        private ArrayList ramBasedFiles = new ArrayList();
        private WriteByteBufferPool bufferPool = new WriteByteBufferPool();
        private int writeBufferSize;
        private int readBufferSize;

        public TransDirectory(String path, int writeBufferSize, int readBufferSize) throws IOException {
            this.dir = new File(path);
            this.writeBufferSize = writeBufferSize;
            this.readBufferSize = readBufferSize;
            if (!this.dir.exists() && !this.dir.mkdirs()) {
                throw new IOException("Cannot create trans directory [" + this.dir.getAbsolutePath() + "]");
            }
            this.raf = new RandomAccessFile(new File(this.dir, "tansdata"), "rw");
            this.files = new HashMap();
        }

        public File getFile() {
            return this.dir;
        }

        public String[] list() throws IOException {
            String[] list = new String[this.files.size()];
            int count = 0;
            Iterator it = this.files.values().iterator();
            while (it.hasNext()) {
                FileEntry entry = (FileEntry)it.next();
                if (entry.deleted) continue;
                list[count++] = entry.name;
            }
            return list;
        }

        public boolean fileExists(String name) throws IOException {
            return this.files.containsKey(name);
        }

        public long fileModified(String name) throws IOException {
            return ((FileEntry)this.files.get((Object)name)).lastModified;
        }

        public void touchFile(String name) throws IOException {
            ((FileEntry)this.files.get((Object)name)).lastModified = System.currentTimeMillis();
        }

        public void deleteFile(String name) throws IOException {
            ((FileEntry)this.files.get((Object)name)).deleted = true;
        }

        public void renameFile(String from, String to) throws IOException {
            FileEntry fileEnty = (FileEntry)this.files.get(from);
            fileEnty.name = to;
            this.files.put(to, fileEnty);
        }

        public long fileLength(String name) throws IOException {
            return ((FileEntry)this.files.get((Object)name)).length;
        }

        public IndexOutput createOutput(String name) throws IOException {
            FileEntry fileEntry = new FileEntry();
            fileEntry.name = name;
            this.files.put(name, fileEntry);
            this.ramBasedFiles.add(fileEntry);
            return new RamTransIndexOutput(fileEntry);
        }

        public IndexInput openInput(String name) throws IOException {
            FileEntry fileEntry = (FileEntry)this.files.get(name);
            return new TransIndexInput(this.raf, fileEntry);
        }

        public void flush() throws IOException {
            this.raf.seek(this.raf.length());
            for (int feIndex = 0; feIndex < this.ramBasedFiles.size(); ++feIndex) {
                FileEntry fileEntry = (FileEntry)this.ramBasedFiles.get(feIndex);
                fileEntry.startPosition = this.raf.length();
                if (fileEntry.buffers.size() == 0) continue;
                if (fileEntry.buffers.size() == 1) {
                    this.raf.write((byte[])fileEntry.buffers.get(0), 0, (int)fileEntry.length);
                } else {
                    int i;
                    int tempSize = fileEntry.buffers.size() - 1;
                    for (i = 0; i < tempSize; ++i) {
                        this.raf.write((byte[])fileEntry.buffers.get(i), 0, this.writeBufferSize);
                    }
                    int leftOver = (int)(fileEntry.length % (long)this.writeBufferSize);
                    if (leftOver == 0) {
                        this.raf.write((byte[])fileEntry.buffers.get(i), 0, this.writeBufferSize);
                    } else {
                        this.raf.write((byte[])fileEntry.buffers.get(i), 0, leftOver);
                    }
                }
                this.bufferPool.put(fileEntry.buffers);
                fileEntry.buffers = null;
            }
            this.ramBasedFiles.clear();
        }

        public Lock makeLock(String name) {
            throw new UnsupportedOperationException("Lokcing is not supported for trans directory");
        }

        public void close() throws IOException {
            this.raf.close();
        }

        class TransIndexInput
        extends ConfigurableBufferedIndexInput {
            private RandomAccessFile raf;
            private FileEntry fileEntry;

            public TransIndexInput(RandomAccessFile raf, FileEntry fileEntry) throws IOException {
                this.raf = raf;
                this.fileEntry = fileEntry;
                this.initBuffer(TransDirectory.this.readBufferSize);
            }

            protected void readInternal(byte[] b, int offset, int length) throws IOException {
                int i;
                this.raf.seek(this.fileEntry.startPosition + this.getFilePointer());
                int total = 0;
                do {
                    if ((i = this.raf.read(b, offset + total, length - total)) != -1) continue;
                    throw new IOException("Read past EOF [" + this.fileEntry.name + "] SIZE [" + this.fileEntry.length + "]");
                } while ((total += i) < length);
            }

            protected void seekInternal(long pos) throws IOException {
            }

            public void close() throws IOException {
            }

            public long length() {
                return this.fileEntry.length;
            }
        }

        class RamTransIndexOutput
        extends ConfigurableBufferedIndexOutput {
            private long pointer = 0L;
            private FileEntry fileEntry;

            public RamTransIndexOutput(FileEntry fileEntry) {
                this.fileEntry = fileEntry;
                this.fileEntry.buffers = new ArrayList();
                this.initBuffer(TransDirectory.this.writeBufferSize);
            }

            public void flushBuffer(byte[] src, int len) {
                int bufferPos = 0;
                while (bufferPos != len) {
                    byte[] buffer;
                    int remainInSrcBuffer;
                    int bytesToCopy;
                    int bufferNumber = (int)(this.pointer / (long)TransDirectory.this.writeBufferSize);
                    int bufferOffset = (int)(this.pointer % (long)TransDirectory.this.writeBufferSize);
                    int bytesInBuffer = TransDirectory.this.writeBufferSize - bufferOffset;
                    int n = bytesToCopy = bytesInBuffer >= (remainInSrcBuffer = len - bufferPos) ? remainInSrcBuffer : bytesInBuffer;
                    if (bufferNumber == this.fileEntry.buffers.size()) {
                        buffer = TransDirectory.this.bufferPool.get();
                        this.fileEntry.buffers.add(buffer);
                    } else {
                        buffer = (byte[])this.fileEntry.buffers.get(bufferNumber);
                    }
                    System.arraycopy(src, bufferPos, buffer, bufferOffset, bytesToCopy);
                    bufferPos += bytesToCopy;
                    this.pointer += (long)bytesToCopy;
                }
                if (this.pointer > this.fileEntry.length) {
                    this.fileEntry.length = this.pointer;
                }
                this.fileEntry.lastModified = System.currentTimeMillis();
            }

            public void close() throws IOException {
                super.close();
            }

            public void seek(long pos) throws IOException {
                super.seek(pos);
                this.pointer = pos;
            }

            public long length() {
                return this.fileEntry.length;
            }
        }

        class WriteByteBufferPool {
            private LinkedList pool = new LinkedList();

            WriteByteBufferPool() {
            }

            public byte[] get() {
                if (this.pool.size() == 0) {
                    return new byte[TransDirectory.this.writeBufferSize];
                }
                return (byte[])this.pool.removeFirst();
            }

            public void put(byte[] data) {
                this.pool.add(data);
            }

            public void put(List data) {
                this.pool.addAll(data);
            }
        }

        class FileEntry {
            String name;
            long lastModified;
            boolean deleted;
            long startPosition;
            long length;
            ArrayList buffers;

            FileEntry() {
            }
        }
    }
}

